/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.fabricmc.fabric.impl.registry.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.RemapException;
import net.fabricmc.fabric.impl.registry.RemappableRegistry;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_29;
import net.minecraft.class_31;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_29.class})
public class MixinWorldSaveHandler {
    private static final int FABRIC_ID_REGISTRY_BACKUPS = 3;
    @Shadow
    private static Logger field_149;
    @Shadow
    public File field_145;
    private class_2487 fabric_lastSavedIdMap = null;

    private boolean fabric_readIdMapFile(File file) throws IOException, RemapException {
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            class_2487 tag = class_2507.method_10629((InputStream)fileInputStream);
            fileInputStream.close();
            if (tag != null) {
                RegistrySyncManager.apply(tag, RemappableRegistry.RemapMode.AUTHORITATIVE);
                return true;
            }
        }
        return false;
    }

    private File getWorldIdMapFile(int i) {
        return new File(new File(this.field_145, "data"), "fabricRegistry.dat" + (i == 0 ? "" : "." + i));
    }

    @Inject(method={"readProperties"}, at={@At(value="HEAD")})
    public void readWorldProperties(CallbackInfoReturnable<class_31> callbackInfo) {
        class_2487 newIdMap;
        for (int i = 0; i < 3; ++i) {
            field_149.info("Loading Fabric registry [file " + (i + 1) + "/" + 4 + "]");
            try {
                if (!this.fabric_readIdMapFile(this.getWorldIdMapFile(i))) continue;
                break;
            }
            catch (IOException e) {
                if (i >= 2) {
                    throw new RuntimeException(e);
                }
                field_149.warn("Reading registry file failed!", (Throwable)e);
                continue;
            }
            catch (RemapException e) {
                throw new RuntimeException("Remapping world failed!", e);
            }
        }
        if (!(newIdMap = RegistrySyncManager.toTag(false)).equals((Object)this.fabric_lastSavedIdMap)) {
            for (int i = 2; i >= 0; --i) {
                File file = this.getWorldIdMapFile(i);
                if (!file.exists()) continue;
                if (i == 2) {
                    file.delete();
                    continue;
                }
                File target = this.getWorldIdMapFile(i + 1);
                file.renameTo(target);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.getWorldIdMapFile(0));
                class_2507.method_10634((class_2487)newIdMap, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                field_149.warn("Failed to save registry file!", (Throwable)e);
            }
            this.fabric_lastSavedIdMap = newIdMap;
        }
    }
}

