/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.renderer;

import java.util.Random;
import java.util.function.Supplier;

import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;

/**
 * Specialized model wrapper that implements a general-purpose 
 * block-breaking render for enhanced models.<p>
 * 
 * Works by intercepting all model output and redirecting to dynamic
 * quads that are baked with single-layer, UV-locked damage texture.
 */
public class DamageModel extends ForwardingBakedModel {
    static final RenderMaterial DAMAGE_MATERIAL = RendererAccess.INSTANCE.hasRenderer() ? RendererAccess.INSTANCE.getRenderer().materialFinder().find() : null;
    
    private DamageTransform damageTransform = new DamageTransform();
    
    public void prepare(class_1087 wrappedModel, class_1058 sprite, class_2680 blockState, class_2338 blockPos) {
        this.damageTransform.damageSprite = sprite;
        this.wrapped = wrappedModel;
    }
    
    @Override
    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        context.pushTransform(damageTransform);
        ((FabricBakedModel)wrapped).emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }
    
    private static class DamageTransform implements RenderContext.QuadTransform {
        private class_1058 damageSprite;
        
        @Override
        public boolean transform(MutableQuadView quad) {
            quad.material(DAMAGE_MATERIAL);
            quad.spriteBake(0, damageSprite, MutableQuadView.BAKE_LOCK_UV);
            quad.colorIndex(-1);
            return true;
        }
    }
}
