/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client;

import java.util.Random;

import net.fabricmc.fabric.impl.renderer.DamageModel;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_289;
import net.minecraft.class_776;
import net.minecraft.class_778;
import org.apache.commons.lang3.tuple.MutablePair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;

/**
 * Implements hook for block-breaking render.
 */
@Mixin(class_776.class)
public abstract class MixinBlockRenderManager {
    @Shadow private class_778 renderer;
    @Shadow private Random random;
    
    private static final ThreadLocal<MutablePair<DamageModel, class_1087>> DAMAGE_STATE = ThreadLocal.withInitial(() -> MutablePair.of(new DamageModel(), null));
    
    /**
     * Intercept the model assignment from getModel() - simpler than capturing entire LVT.
     */
    @ModifyVariable(method = "tesselateDamage", at = @At(value = "STORE", ordinal = 0), allow = 1, require = 1)
    private class_1087 hookTesselateDamageModel(class_1087 modelIn) {
        DAMAGE_STATE.get().right = modelIn;
        return modelIn;
    }
    
    /**
     * If the model we just captured is a fabric model, render it using a specialized 
     * damage render context and cancel rest of the logic. Avoids creating a bunch of
     * vanilla quads for complex meshes and honors dynamic model geometry.
     */
    @Inject(method = "tesselateDamage", cancellable = true, 
            at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/client/render/block/BlockModels;getModel(Lnet/minecraft/block/BlockState;)Lnet/minecraft/client/render/model/BakedModel;"))
    private void hookTesselateDamage(class_2680 blockState, class_2338 blockPos, class_1058 sprite, class_1920 blockView, CallbackInfo ci) {
        MutablePair<DamageModel, class_1087> damageState = DAMAGE_STATE.get();
        if(damageState.right != null && !((FabricBakedModel)damageState.right).isVanillaAdapter()) {
            damageState.left.prepare(damageState.right, sprite, blockState, blockPos);
            this.renderer.method_3374(blockView, damageState.left, blockState, blockPos, class_289.method_1348().method_1349(), true, this.random, blockState.method_11617(blockPos));
            ci.cancel();
        }
    }
}
