/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.renderer.block.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.client.renderer.v1.model.MeshQuadCollection;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SimpleModelWrapper.class})
abstract class SimpleModelWrapperMixin
implements BlockModelPart {
    @Shadow
    @Final
    private QuadCollection quads;
    @Shadow
    @Final
    private boolean useAmbientOcclusion;

    SimpleModelWrapperMixin() {
    }

    @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/resources/Identifier;Lnet/minecraft/client/resources/model/ModelState;)Lnet/minecraft/client/renderer/block/model/BlockModelPart;"}, at={@At(value="INVOKE", target="net/minecraft/client/resources/model/QuadCollection.getAll()Ljava/util/List;")})
    private static void validateMeshAtlas(ModelBaker modelBakery, Identifier location, ModelState state, CallbackInfoReturnable<BlockModelPart> cir, @Local QuadCollection geometry, @Local LocalRef<Multimap<Identifier, Identifier>> forbiddenSpritesRef) {
        if (geometry instanceof MeshQuadCollection) {
            MeshQuadCollection meshGeometry = (MeshQuadCollection)geometry;
            meshGeometry.getMesh().forEach(quad -> {
                if (quad.atlas() != QuadAtlas.BLOCK) {
                    Multimap forbiddenSprites = (Multimap)forbiddenSpritesRef.get();
                    if (forbiddenSprites == null) {
                        forbiddenSprites = HashMultimap.create();
                        forbiddenSpritesRef.set((Object)forbiddenSprites);
                    }
                    TextureAtlasSprite sprite = modelBakery.sprites().spriteFinder(quad.atlas()).find((QuadView)quad);
                    forbiddenSprites.put((Object)sprite.atlasLocation(), (Object)sprite.contents().name());
                }
            });
        }
    }

    public void emitQuads(QuadEmitter emitter, Predicate<@Nullable Direction> cullTest) {
        QuadCollection quadCollection = this.quads;
        if (quadCollection instanceof MeshQuadCollection) {
            MeshQuadCollection meshQuadCollection = (MeshQuadCollection)quadCollection;
            if (this.useAmbientOcclusion) {
                meshQuadCollection.getMesh().outputTo(emitter);
            } else {
                emitter.pushTransform(quad -> {
                    if (quad.ambientOcclusion() == TriState.DEFAULT) {
                        quad.ambientOcclusion(TriState.FALSE);
                    }
                    return true;
                });
                meshQuadCollection.getMesh().outputTo(emitter);
                emitter.popTransform();
            }
        } else {
            super.emitQuads(emitter, cullTest);
        }
    }
}

