/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.renderer.block.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.fabricmc.fabric.api.client.renderer.v1.render.ChunkSectionLayerHelper;
import net.fabricmc.fabric.api.client.renderer.v1.render.FabricModelBlockRenderer;
import net.fabricmc.fabric.impl.client.renderer.DelegatingBlockMultiBufferSourceImpl;
import net.fabricmc.fabric.impl.client.renderer.ExtendedBlockModelSubmit;
import net.fabricmc.fabric.impl.client.renderer.ExtendedBlockSubmit;
import net.fabricmc.fabric.impl.client.renderer.SubmitNodeCollectionExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.MovingBlockRenderState;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.feature.BlockFeatureRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockFeatureRenderer.class})
abstract class BlockFeatureRendererMixin {
    @Shadow
    @Final
    private PoseStack poseStack;

    BlockFeatureRendererMixin() {
    }

    @Inject(method={"renderMovingBlockSubmits"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=0)})
    private void beforeRenderMovingBlocks(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, BlockRenderDispatcher blockRenderDispatcher, boolean translucent, CallbackInfo ci, @Local Iterator<SubmitNodeStorage.MovingBlockSubmit> iterator) {
        while (iterator.hasNext()) {
            SubmitNodeStorage.MovingBlockSubmit command = iterator.next();
            MovingBlockRenderState renderState = command.movingBlockRenderState();
            BlockState blockState = renderState.blockState;
            BlockStateModel model = blockRenderDispatcher.getBlockModel(blockState);
            long seed = blockState.getSeed(renderState.randomSeedPos);
            this.poseStack.pushPose();
            this.poseStack.mulPose((Matrix4fc)command.pose());
            blockRenderDispatcher.getModelRenderer().render((BlockAndTintGetter)renderState, model, blockState, renderState.blockPos, this.poseStack, ChunkSectionLayerHelper.movingDelegate((MultiBufferSource)bufferSource), false, seed, OverlayTexture.NO_OVERLAY);
            this.poseStack.popPose();
        }
    }

    @Inject(method={"renderBlockSubmits"}, at={@At(value="RETURN")})
    private void onReturnRender(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, BlockRenderDispatcher blockRenderDispatcher, OutlineBufferSource outlineBufferSource, boolean translucent, CallbackInfo ci) {
        DelegatingBlockMultiBufferSourceImpl blockMultiBufferSource = new DelegatingBlockMultiBufferSourceImpl();
        for (ExtendedBlockSubmit extendedBlockSubmit : ((SubmitNodeCollectionExtension)nodeCollection).fabric_getExtendedBlockSubmits()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(extendedBlockSubmit.pose());
            blockRenderDispatcher.renderBlockAsEntity(extendedBlockSubmit.state(), this.poseStack, (MultiBufferSource)bufferSource, extendedBlockSubmit.lightCoords(), extendedBlockSubmit.overlayCoords(), extendedBlockSubmit.level(), extendedBlockSubmit.pos());
            if (extendedBlockSubmit.outlineColor() != 0) {
                outlineBufferSource.setColor(extendedBlockSubmit.outlineColor());
                blockRenderDispatcher.renderBlockAsEntity(extendedBlockSubmit.state(), this.poseStack, (MultiBufferSource)outlineBufferSource, extendedBlockSubmit.lightCoords(), extendedBlockSubmit.overlayCoords(), extendedBlockSubmit.level(), extendedBlockSubmit.pos());
            }
            this.poseStack.popPose();
        }
        for (ExtendedBlockModelSubmit extendedBlockModelSubmit : ((SubmitNodeCollectionExtension)nodeCollection).fabric_getExtendedBlockModelSubmits()) {
            blockMultiBufferSource.renderTypeFunction = extendedBlockModelSubmit.renderTypeFunction();
            blockMultiBufferSource.multiBufferSource = bufferSource;
            FabricModelBlockRenderer.render(extendedBlockModelSubmit.pose(), blockMultiBufferSource, extendedBlockModelSubmit.model(), extendedBlockModelSubmit.r(), extendedBlockModelSubmit.g(), extendedBlockModelSubmit.b(), extendedBlockModelSubmit.lightCoords(), extendedBlockModelSubmit.overlayCoords(), extendedBlockModelSubmit.level(), extendedBlockModelSubmit.pos(), extendedBlockModelSubmit.state());
            if (extendedBlockModelSubmit.outlineColor() == 0) continue;
            outlineBufferSource.setColor(extendedBlockModelSubmit.outlineColor());
            blockMultiBufferSource.multiBufferSource = outlineBufferSource;
            FabricModelBlockRenderer.render(extendedBlockModelSubmit.pose(), blockMultiBufferSource, extendedBlockModelSubmit.model(), extendedBlockModelSubmit.r(), extendedBlockModelSubmit.g(), extendedBlockModelSubmit.b(), extendedBlockModelSubmit.lightCoords(), extendedBlockModelSubmit.overlayCoords(), extendedBlockModelSubmit.level(), extendedBlockModelSubmit.pos(), extendedBlockModelSubmit.state());
        }
    }
}

