/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.renderer.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.renderer.v1.render.BlockMultiBufferSource;
import net.fabricmc.fabric.api.client.renderer.v1.render.ChunkSectionLayerHelper;
import net.fabricmc.fabric.api.client.renderer.v1.render.FabricModelBlockRenderer;
import net.fabricmc.fabric.impl.client.renderer.DelegatingBlockMultiBufferSourceImpl;
import net.fabricmc.fabric.impl.client.renderer.ExtendedBlockModelSubmit;
import net.fabricmc.fabric.impl.client.renderer.ExtendedBlockSubmit;
import net.fabricmc.fabric.impl.client.renderer.SubmitNodeCollectionExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.MovingBlockRenderState;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.feature.BlockFeatureRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.EmptyBlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockFeatureRenderer.class})
abstract class BlockFeatureRendererMixin {
    @Shadow
    @Final
    private PoseStack poseStack;

    BlockFeatureRendererMixin() {
    }

    @Overwrite
    private void renderMovingBlockSubmits(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, BlockRenderDispatcher blockRenderDispatcher, boolean translucent) {
        BlockMultiBufferSource blockBufferSource = ChunkSectionLayerHelper.movingDelegate((MultiBufferSource)bufferSource);
        Predicate<ChunkSectionLayer> layerFilter = translucent ? layer -> layer == ChunkSectionLayer.TRANSLUCENT : layer -> layer != ChunkSectionLayer.TRANSLUCENT;
        for (SubmitNodeStorage.MovingBlockSubmit submit : nodeCollection.getMovingBlockSubmits()) {
            MovingBlockRenderState renderState = submit.movingBlockRenderState();
            BlockState blockState = renderState.blockState;
            BlockStateModel model = blockRenderDispatcher.getBlockModel(blockState);
            long seed = blockState.getSeed(renderState.randomSeedPos);
            this.poseStack.pushPose();
            this.poseStack.mulPose((Matrix4fc)submit.pose());
            blockRenderDispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)renderState, model, blockState, renderState.blockPos, this.poseStack, blockBufferSource, layerFilter, false, seed, OverlayTexture.NO_OVERLAY);
            this.poseStack.popPose();
        }
    }

    @Overwrite
    private void renderBlockSubmits(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, BlockRenderDispatcher blockRenderDispatcher, OutlineBufferSource outlineBufferSource, boolean translucent) {
        Predicate<ChunkSectionLayer> layerFilter = translucent ? layer -> layer == ChunkSectionLayer.TRANSLUCENT : layer -> layer != ChunkSectionLayer.TRANSLUCENT;
        for (SubmitNodeStorage.BlockSubmit blockSubmit : nodeCollection.getBlockSubmits()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(blockSubmit.pose());
            blockRenderDispatcher.renderSingleBlock(blockSubmit.state(), this.poseStack, (MultiBufferSource)bufferSource, layerFilter, blockSubmit.lightCoords(), blockSubmit.overlayCoords(), (BlockAndTintGetter)EmptyBlockAndTintGetter.INSTANCE, BlockPos.ZERO);
            if (blockSubmit.outlineColor() != 0) {
                outlineBufferSource.setColor(blockSubmit.outlineColor());
                blockRenderDispatcher.renderSingleBlock(blockSubmit.state(), this.poseStack, (MultiBufferSource)outlineBufferSource, layerFilter, blockSubmit.lightCoords(), blockSubmit.overlayCoords(), (BlockAndTintGetter)EmptyBlockAndTintGetter.INSTANCE, BlockPos.ZERO);
            }
            this.poseStack.popPose();
        }
        for (ExtendedBlockSubmit extendedBlockSubmit : ((SubmitNodeCollectionExtension)nodeCollection).fabric_getExtendedBlockSubmits()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(extendedBlockSubmit.pose());
            blockRenderDispatcher.renderSingleBlock(extendedBlockSubmit.state(), this.poseStack, (MultiBufferSource)bufferSource, layerFilter, extendedBlockSubmit.lightCoords(), extendedBlockSubmit.overlayCoords(), extendedBlockSubmit.level(), extendedBlockSubmit.pos());
            if (extendedBlockSubmit.outlineColor() != 0) {
                outlineBufferSource.setColor(extendedBlockSubmit.outlineColor());
                blockRenderDispatcher.renderSingleBlock(extendedBlockSubmit.state(), this.poseStack, (MultiBufferSource)outlineBufferSource, layerFilter, extendedBlockSubmit.lightCoords(), extendedBlockSubmit.overlayCoords(), extendedBlockSubmit.level(), extendedBlockSubmit.pos());
            }
            this.poseStack.popPose();
        }
    }

    @Inject(method={"renderBlockModelSubmits"}, at={@At(value="RETURN")})
    private void onReturnRenderBlockModelSubmits(SubmitNodeCollection nodeCollection, MultiBufferSource.BufferSource bufferSource, OutlineBufferSource outlineBufferSource, boolean translucent, CallbackInfo ci) {
        DelegatingBlockMultiBufferSourceImpl blockMultiBufferSource = new DelegatingBlockMultiBufferSourceImpl(translucent);
        for (ExtendedBlockModelSubmit submit : ((SubmitNodeCollectionExtension)nodeCollection).fabric_getExtendedBlockModelSubmits()) {
            blockMultiBufferSource.renderTypeFunction = submit.renderTypeFunction();
            blockMultiBufferSource.multiBufferSource = bufferSource;
            FabricModelBlockRenderer.renderModel(submit.pose(), blockMultiBufferSource, blockMultiBufferSource, submit.model(), submit.r(), submit.g(), submit.b(), submit.lightCoords(), submit.overlayCoords(), submit.level(), submit.pos(), submit.state());
            if (submit.outlineColor() == 0) continue;
            outlineBufferSource.setColor(submit.outlineColor());
            blockMultiBufferSource.multiBufferSource = outlineBufferSource;
            FabricModelBlockRenderer.renderModel(submit.pose(), blockMultiBufferSource, blockMultiBufferSource, submit.model(), submit.r(), submit.g(), submit.b(), submit.lightCoords(), submit.overlayCoords(), submit.level(), submit.pos(), submit.state());
        }
    }
}

