/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

@Mixin(class_1095.class)
public class MultipartBakedModelMixin implements FabricBakedModel {
	@Shadow
	@Final
	private List<Pair<Predicate<class_2680>, class_1087>> components;

	@Shadow
	@Final
	private Map<class_2680, BitSet> stateCache;

	@Unique
	boolean isVanilla = true;

	@Override
	public boolean isVanillaAdapter() {
		return isVanilla;
	}

	@Inject(at = @At("RETURN"), method = "<init>")
	private void onInit(List<Pair<Predicate<class_2680>, class_1087>> components, CallbackInfo cb) {
		for (Pair<Predicate<class_2680>, class_1087> component : components) {
			if (!component.getRight().isVanillaAdapter()) {
				isVanilla = false;
				break;
			}
		}
	}

	@Override
	public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
		BitSet bitSet = this.stateCache.get(state);

		if (bitSet == null) {
			bitSet = new BitSet();

			for (int i = 0; i < this.components.size(); i++) {
				Pair<Predicate<class_2680>, class_1087> pair = components.get(i);

				if (pair.getLeft().test(state)) {
					bitSet.set(i);
				}
			}

			stateCache.put(state, bitSet);
		}

		class_5819 random = randomSupplier.get();
		// Imitate vanilla passing a new random to the submodels
		long randomSeed = random.method_43055();
		Supplier<class_5819> subModelRandomSupplier = () -> {
			random.method_43052(randomSeed);
			return random;
		};

		for (int i = 0; i < this.components.size(); i++) {
			if (bitSet.get(i)) {
				components.get(i).getRight().emitBlockQuads(blockView, state, pos, subModelRandomSupplier, context);
			}
		}
	}

	@Override
	public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
		// Vanilla doesn't use MultipartBakedModel for items.
	}
}
