/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client;

import java.util.function.Predicate;
import java.util.function.Supplier;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.minecraft.class_1087;
import net.minecraft.class_1097;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;

@Mixin(class_1097.class)
abstract class WeightedBakedModelMixin implements FabricBakedModel {
	@Shadow
	@Final
	private class_6005<class_1087> models;

	@Unique
	private boolean isVanilla = true;

	@Inject(at = @At("RETURN"), method = "<init>")
	private void onInit(class_6005<class_1087> dataPool, CallbackInfo ci) {
		for (class_6008.class_6010<class_1087> model : models.method_34994()) {
			if (!model.comp_2542().isVanillaAdapter()) {
				isVanilla = false;
				break;
			}
		}
	}

	@Override
	public boolean isVanillaAdapter() {
		return isVanilla;
	}

	@Override
	public void emitBlockQuads(QuadEmitter emitter, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, Predicate<@Nullable class_2350> cullTest) {
		class_1087 selected = this.models.method_34973(randomSupplier.get()).orElse(null);

		if (selected != null) {
			selected.emitBlockQuads(emitter, blockView, state, pos, () -> {
				class_5819 random = randomSupplier.get();
				random.method_43054(); // Imitate vanilla modifying the random before passing it to the submodel
				return random;
			}, cullTest);
		}
	}

	@Override
	public void emitItemQuads(QuadEmitter emitter, Supplier<class_5819> randomSupplier) {
		class_1087 selected = this.models.method_34973(randomSupplier.get()).orElse(null);

		if (selected != null) {
			selected.emitItemQuads(emitter, () -> {
				class_5819 random = randomSupplier.get();
				random.method_43054(); // Imitate vanilla modifying the random before passing it to the submodel
				return random;
			});
		}
	}
}
