/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

@Mixin(class_1095.class)
abstract class MultipartBakedModelMixin implements class_1087 {
	@Shadow
	@Final
	private List<class_1095.class_10204> selectors;

	@Shadow
	@Final
	private Map<class_2680, BitSet> stateCache;

	@Unique
	private boolean isVanilla = true;

	@Inject(at = @At("RETURN"), method = "<init>")
	private void onInit(List<class_1095.class_10204> selectors, CallbackInfo ci) {
		for (class_1095.class_10204 selector : selectors) {
			if (!selector.comp_3204().isVanillaAdapter()) {
				isVanilla = false;
				break;
			}
		}
	}

	@Override
	public boolean isVanillaAdapter() {
		return isVanilla;
	}

	@Override
	public void emitBlockQuads(QuadEmitter emitter, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, Predicate<@Nullable class_2350> cullTest) {
		BitSet bitSet = this.stateCache.get(state);

		if (bitSet == null) {
			bitSet = new BitSet();

			for (int i = 0; i < this.selectors.size(); i++) {
				class_1095.class_10204 selector = selectors.get(i);

				if (selector.comp_3203().test(state)) {
					bitSet.set(i);
				}
			}

			stateCache.put(state, bitSet);
		}

		class_5819 random = randomSupplier.get();
		// Imitate vanilla passing a new random to the submodels
		long randomSeed = random.method_43055();
		Supplier<class_5819> subModelRandomSupplier = () -> {
			random.method_43052(randomSeed);
			return random;
		};

		for (int i = 0; i < this.selectors.size(); i++) {
			if (bitSet.get(i)) {
				selectors.get(i).comp_3204().emitBlockQuads(emitter, blockView, state, pos, subModelRandomSupplier, cullTest);
			}
		}
	}

	@Override
	public void emitItemQuads(QuadEmitter emitter, Supplier<class_5819> randomSupplier) {
		// Vanilla doesn't use MultipartBakedModel for items.
	}
}
