/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client;

import java.util.function.Predicate;
import java.util.function.Supplier;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10200;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

@Mixin(class_10200.class)
abstract class WrapperBakedModelMixin implements class_1087 {
	@Shadow
	@Final
	protected class_1087 wrapped;

	@Override
	public boolean isVanillaAdapter() {
		return wrapped.isVanillaAdapter();
	}

	@Override
	public void emitBlockQuads(QuadEmitter emitter, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, Predicate<@Nullable class_2350> cullTest) {
		wrapped.emitBlockQuads(emitter, blockView, state, pos, randomSupplier, cullTest);
	}

	@Override
	public void emitItemQuads(QuadEmitter emitter, Supplier<class_5819> randomSupplier) {
		wrapped.emitItemQuads(emitter, randomSupplier);
	}
}
