/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client;

import java.util.Map;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.renderer.SpriteFinderImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_7766;

@Mixin(class_1059.class)
public class SpriteAtlasTextureMixin implements SpriteFinderImpl.SpriteFinderAccess {
	@Final
	@Shadow
	private Map<class_2960, class_1058> sprites;

	private SpriteFinderImpl fabric_spriteFinder = null;

	@Inject(at = @At("RETURN"), method = "upload")
	private void uploadHook(class_7766.class_7767 arg, CallbackInfo ci) {
		fabric_spriteFinder = null;
	}

	@Override
	public SpriteFinderImpl fabric_spriteFinder() {
		SpriteFinderImpl result = fabric_spriteFinder;

		if (result == null) {
			result = new SpriteFinderImpl(sprites, (class_1059) (Object) this);
			fabric_spriteFinder = result;
		}

		return result;
	}
}
