/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class ModelHelper {
    public static final int NULL_FACE_ID = 6;
    private static final class_2350[] FACES = Arrays.copyOf(class_2350.values(), 7);
    public static final class_804 TRANSFORM_BLOCK_GUI = ModelHelper.makeTransform(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    public static final class_804 TRANSFORM_BLOCK_GROUND = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
    public static final class_804 TRANSFORM_BLOCK_FIXED = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    public static final class_804 TRANSFORM_BLOCK_3RD_PERSON_RIGHT = ModelHelper.makeTransform(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
    public static final class_804 TRANSFORM_BLOCK_1ST_PERSON_RIGHT = ModelHelper.makeTransform(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final class_804 TRANSFORM_BLOCK_1ST_PERSON_LEFT = ModelHelper.makeTransform(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final class_809 MODEL_TRANSFORM_BLOCK = new class_809(TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_1ST_PERSON_LEFT, TRANSFORM_BLOCK_1ST_PERSON_RIGHT, class_804.field_4284, TRANSFORM_BLOCK_GUI, TRANSFORM_BLOCK_GROUND, TRANSFORM_BLOCK_FIXED);

    private ModelHelper() {
    }

    public static int toFaceIndex(@Nullable class_2350 face) {
        return face == null ? 6 : face.method_10146();
    }

    @Nullable
    public static class_2350 faceFromIndex(int faceIndex) {
        return FACES[faceIndex];
    }

    public static List<class_777>[] toQuadLists(Mesh mesh) {
        SpriteFinder finder = SpriteFinder.get(class_310.method_1551().method_1554().method_24153(class_1059.field_5275));
        ImmutableList.Builder[] builders = new ImmutableList.Builder[7];
        for (int i = 0; i < 7; ++i) {
            builders[i] = ImmutableList.builder();
        }
        if (mesh != null) {
            mesh.forEach(q -> {
                class_2350 cullFace = q.cullFace();
                builders[cullFace == null ? 6 : cullFace.method_10146()].add((Object)q.toBakedQuad(finder.find((QuadView)q)));
            });
        }
        List[] result = new List[7];
        for (int i = 0; i < 7; ++i) {
            result[i] = builders[i].build();
        }
        return result;
    }

    private static class_804 makeTransform(float rotationX, float rotationY, float rotationZ, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float scaleZ) {
        Vector3f translation = new Vector3f(translationX, translationY, translationZ);
        translation.mul(0.0625f);
        translation.set(class_3532.method_15363((float)translation.x, (float)-5.0f, (float)5.0f), class_3532.method_15363((float)translation.y, (float)-5.0f, (float)5.0f), class_3532.method_15363((float)translation.z, (float)-5.0f, (float)5.0f));
        return new class_804(new Vector3f(rotationX, rotationY, rotationZ), translation, new Vector3f(scaleX, scaleY, scaleZ));
    }
}

