/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.renderer;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class VanillaModelEncoder {
    private static final RenderMaterial STANDARD_MATERIAL = Renderer.get().materialFinder().shadeMode(ShadeMode.VANILLA).find();
    private static final RenderMaterial NO_AO_MATERIAL = Renderer.get().materialFinder().shadeMode(ShadeMode.VANILLA).ambientOcclusion(TriState.FALSE).find();

    public static void emitBlockQuads(QuadEmitter emitter, class_1087 model, @Nullable class_2680 state, Supplier<class_5819> randomSupplier, Predicate<@Nullable class_2350> cullTest) {
        RenderMaterial defaultMaterial = model.method_4708() ? STANDARD_MATERIAL : NO_AO_MATERIAL;
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex(i);
            if (cullTest.test(cullFace)) continue;
            List quads = model.method_4707(state, cullFace, randomSupplier.get());
            int count = quads.size();
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                emitter.fromVanilla(q, defaultMaterial, cullFace);
                emitter.emit();
            }
        }
    }

    public static void emitItemQuads(QuadEmitter emitter, class_1087 model, @Nullable class_2680 state, Supplier<class_5819> randomSupplier) {
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex(i);
            List quads = model.method_4707(state, cullFace, randomSupplier.get());
            int count = quads.size();
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                emitter.fromVanilla(q, STANDARD_MATERIAL, cullFace);
                emitter.emit();
            }
        }
    }
}

