/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.render;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.minecraft.class_10023;
import net.minecraft.class_1087;
import net.minecraft.class_1540;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_897;
import net.minecraft.class_901;

@Mixin(class_901.class)
abstract class FallingBlockEntityRendererMixin extends class_897<class_1540, class_10023> {
	@Shadow
	@Final
	private class_776 blockRenderManager;

	private FallingBlockEntityRendererMixin(class_5617.class_5618 context) {
		super(context);
	}

	// Support multi-render layer models.
	@Overwrite
	public void render(class_10023 renderState, class_4587 matrixStack, class_4597 vertexConsumers, int light) {
		class_2680 blockState = renderState.field_53358;

		if (blockState.method_26217() == class_2464.field_11458) {
			matrixStack.method_22903();
			matrixStack.method_22904(-0.5, 0.0, -0.5);

			class_1087 model = blockRenderManager.method_3349(blockState);
			long seed = blockState.method_26190(renderState.field_53356);
			blockRenderManager.method_3350().render(renderState, model, blockState, renderState.field_53357, matrixStack, layer -> vertexConsumers.getBuffer(RenderLayerHelper.getMovingBlockLayer(layer)), false, seed, class_4608.field_21444);

			matrixStack.method_22909();
			super.method_3936(renderState, matrixStack, vertexConsumers, light);
		}
	}
}
