/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_4696;
import net.minecraft.class_4722;

public final class RenderLayerHelper {
	private RenderLayerHelper() {
	}

	/**
	 * Same logic as {@link class_4696#method_29359}, but accepts a {@link class_1921} from
	 * {@link class_1921#method_22720()} instead of a {@link class_2680}.
	 */
	public static class_1921 getMovingBlockLayer(class_1921 chunkRenderLayer) {
		return chunkRenderLayer == class_1921.method_23583() ? class_1921.method_29380() : chunkRenderLayer;
	}

	/**
	 * Same logic as {@link class_4696#method_23683}, but accepts a {@link class_1921} from
	 * {@link class_1921#method_22720()} instead of a {@link class_2680}.
	 */
	public static class_1921 getEntityBlockLayer(class_1921 chunkRenderLayer) {
		return chunkRenderLayer == class_1921.method_23583() ? class_4722.method_29382() : class_4722.method_24074();
	}
}
