/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10444;

/**
 * Note: This interface is automatically implemented on {@link class_10444.class_10446} via Mixin and interface
 * injection.
 */
public interface FabricLayerRenderState {
	/**
	 * Retrieves the {@link QuadEmitter} used to append quads to this layer. Calling this method a second time
	 * invalidates any prior result. Geometry added to this emitter will not be visible in
	 * {@link class_10444.class_10446#method_67997()} and will be rendered after any
	 * {@linkplain class_10444.class_10446#method_67997() vanilla quads} when this layer is rendered. Vertex
	 * positions of geometry added to this emitter will automatically be output on
	 * {@link class_10444#method_67991(Consumer)} ({@link class_10444.class_10446#method_67995(Supplier)} must still
	 * be used to add positions of {@linkplain class_10444.class_10446#method_67997() vanilla quads}). Adding quads
	 * that use animated sprites to this emitter will not automatically call {@link class_10444#method_70947()}. Any
	 * quads added to this emitter will be cleared on {@link class_10444.class_10446#method_65612()}.
	 *
	 * <p>Do not retain references outside the context of this layer.
	 */
	default QuadEmitter emitter() {
		return Renderer.get().getLayerRenderStateEmitter((class_10444.class_10446) this);
	}
}
