/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10515;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_11785;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_9891;

/**
 * Note: This interface is automatically implemented on {@link class_11785} via Mixin and interface injection.
 */
public interface FabricRenderCommandQueue {
	/**
	 * Alternative for
	 * {@link class_11785#method_73481(class_4587, class_2680, int, int, int)} that additionally accepts the
	 * {@link class_1920} and {@link class_2338} to pass to
	 * {@link class_1087#emitQuads(QuadEmitter, class_1920, class_2338, class_2680, class_5819, Predicate)} when
	 * necessary. <b>Prefer using this method over the vanilla alternative to correctly render models that have geometry
	 * on multiple render layers and to provide the model with additional context.</b>
	 *
	 * <p>This method allows rendering a block model with minimal transformations to the model geometry. Also invokes
	 * the {@link class_10515}. Usually used by entity renderers.
	 *
	 * @param matrices The matrices.
	 * @param state The block state.
	 * @param light The minimum light value.
	 * @param overlay The overlay value.
	 * @param outlineColor The outline color.
	 * @param blockView The world in which to render the model. <b>Can be empty (i.e. {@link class_9891}).</b>
	 *                  <b>Must not be mutated after calling this method.</b>
	 * @param pos The position of the block in the world. <b>Should be {@link class_2338#field_10980} if the world is empty.
	 *            </b> <b>Must not be mutated after calling this method.</b>
	 *
	 * @see FabricBlockRenderManager#renderBlockAsEntity(class_2680, class_4587, class_4597, int, int, class_1920, class_2338)
	 */
	default void submitBlock(class_4587 matrices, class_2680 state, int light, int overlay, int outlineColor, class_1920 blockView, class_2338 pos) {
		((class_11785) this).method_73481(matrices, state, light, overlay, outlineColor);
	}

	/**
	 * Alternative for
	 * {@link class_11785#method_73484(class_4587, class_1921, class_1087, float, float, float, int, int, int)}
	 * that accepts a {@code Function<BlockRenderLayer, RenderLayer>} instead of a {@link class_1921}. Also accepts the
	 * {@link class_1920}, {@link class_2338}, and {@link class_2680} to pass to
	 * {@link class_1087#emitQuads(QuadEmitter, class_1920, class_2338, class_2680, class_5819, Predicate)} when
	 * necessary. <b>Prefer using this method over the vanilla alternative to correctly render models that have geometry
	 * on multiple render layers and to provide the model with additional context.</b>
	 *
	 * <p>This method allows rendering a block model with minimal transformations to the model geometry. Usually used by
	 * entity renderers.
	 *
	 * @param matrices The matrices.
	 * @param renderLayerFunction The function to use to convert {@link class_11515}s to {@link class_1921}s.
	 *                            <b>Must not be mutated after calling this method.</b>
	 * @param model The model to render.
	 * @param r The red component of the tint color.
	 * @param g The green component of the tint color.
	 * @param b The blue component of the tint color.
	 * @param light The minimum light value.
	 * @param overlay The overlay value.
	 * @param outlineColor The outline color.
	 * @param blockView The world in which to render the model. <b>Can be empty (i.e. {@link class_9891}).</b>
	 *                  <b>Must not be mutated after calling this method.</b>
	 * @param pos The position of the block in the world. <b>Should be {@link class_2338#field_10980} if the world is empty.
	 *            </b> <b>Must not be mutated after calling this method.</b>
	 * @param state The block state. <b>Should be {@code Blocks.AIR.getDefaultState()} if not applicable.</b>
	 *
	 * @see FabricBlockModelRenderer#render(class_4587.class_4665, BlockVertexConsumerProvider, class_1087, float, float, float, int, int, class_1920, class_2338, class_2680)
	 */
	default void submitBlockStateModel(class_4587 matrices, Function<class_11515, class_1921> renderLayerFunction, class_1087 model, float r, float g, float b, int light, int overlay, int outlineColor, class_1920 blockView, class_2338 pos, class_2680 state) {
		((class_11785) this).method_73484(matrices, renderLayerFunction.apply(class_4696.method_23679(state)), model, r, g, b, light, overlay, outlineColor);
	}
}
