/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.mesh;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public interface QuadEmitter
extends MutableQuadView {
    public static final float CULL_FACE_EPSILON = 1.0E-5f;

    @Override
    public QuadEmitter pos(int var1, float var2, float var3, float var4);

    @Override
    default public QuadEmitter pos(int vertexIndex, Vector3f pos) {
        MutableQuadView.super.pos(vertexIndex, pos);
        return this;
    }

    @Override
    default public QuadEmitter pos(int vertexIndex, Vector3fc pos) {
        MutableQuadView.super.pos(vertexIndex, pos);
        return this;
    }

    @Override
    public QuadEmitter color(int var1, int var2);

    @Override
    default public QuadEmitter color(int c0, int c1, int c2, int c3) {
        MutableQuadView.super.color(c0, c1, c2, c3);
        return this;
    }

    @Override
    public QuadEmitter uv(int var1, float var2, float var3);

    @Override
    default public QuadEmitter uv(int vertexIndex, Vector2f uv) {
        MutableQuadView.super.uv(vertexIndex, uv);
        return this;
    }

    @Override
    default public QuadEmitter uv(int vertexIndex, Vector2fc uv) {
        MutableQuadView.super.uv(vertexIndex, uv);
        return this;
    }

    @Override
    default public QuadEmitter spriteBake(class_1058 sprite, int bakeFlags) {
        MutableQuadView.super.spriteBake(sprite, bakeFlags);
        return this;
    }

    default public QuadEmitter uvUnitSquare() {
        this.uv(0, 0.0f, 0.0f);
        this.uv(1, 0.0f, 1.0f);
        this.uv(2, 1.0f, 1.0f);
        this.uv(3, 1.0f, 0.0f);
        return this;
    }

    @Override
    public QuadEmitter lightmap(int var1, int var2);

    @Override
    default public QuadEmitter lightmap(int l0, int l1, int l2, int l3) {
        MutableQuadView.super.lightmap(l0, l1, l2, l3);
        return this;
    }

    @Override
    public QuadEmitter normal(int var1, float var2, float var3, float var4);

    @Override
    default public QuadEmitter normal(int vertexIndex, Vector3f normal) {
        MutableQuadView.super.normal(vertexIndex, normal);
        return this;
    }

    @Override
    default public QuadEmitter normal(int vertexIndex, Vector3fc normal) {
        MutableQuadView.super.normal(vertexIndex, normal);
        return this;
    }

    @Override
    public QuadEmitter nominalFace(@Nullable class_2350 var1);

    @Override
    public QuadEmitter cullFace(@Nullable class_2350 var1);

    @Override
    public QuadEmitter renderLayer(@Nullable class_11515 var1);

    @Override
    public QuadEmitter emissive(boolean var1);

    @Override
    public QuadEmitter diffuseShade(boolean var1);

    @Override
    public QuadEmitter ambientOcclusion(TriState var1);

    @Override
    public QuadEmitter glint(@Nullable class_10444.class_10445 var1);

    @Override
    public QuadEmitter shadeMode(ShadeMode var1);

    @Override
    public QuadEmitter tintIndex(int var1);

    @Override
    public QuadEmitter tag(int var1);

    @Override
    public QuadEmitter copyFrom(QuadView var1);

    @Override
    public QuadEmitter fromVanilla(int[] var1, int var2);

    @Override
    public QuadEmitter fromBakedQuad(class_777 var1);

    default public QuadEmitter square(class_2350 nominalFace, float left, float bottom, float right, float top, float depth) {
        if (Math.abs(depth) < 1.0E-5f) {
            this.cullFace(nominalFace);
            depth = 0.0f;
        } else {
            this.cullFace(null);
        }
        this.nominalFace(nominalFace);
        switch (nominalFace) {
            case field_11036: {
                depth = 1.0f - depth;
                top = 1.0f - top;
                bottom = 1.0f - bottom;
            }
            case field_11033: {
                this.pos(0, left, depth, top);
                this.pos(1, left, depth, bottom);
                this.pos(2, right, depth, bottom);
                this.pos(3, right, depth, top);
                break;
            }
            case field_11034: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case field_11039: {
                this.pos(0, depth, top, left);
                this.pos(1, depth, bottom, left);
                this.pos(2, depth, bottom, right);
                this.pos(3, depth, top, right);
                break;
            }
            case field_11035: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case field_11043: {
                this.pos(0, 1.0f - left, top, depth);
                this.pos(1, 1.0f - left, bottom, depth);
                this.pos(2, 1.0f - right, bottom, depth);
                this.pos(3, 1.0f - right, top, depth);
            }
        }
        return this;
    }

    public void pushTransform(QuadTransform var1);

    public void popTransform();

    public QuadEmitter emit();
}

