/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.renderer;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.minecraft.class_11605;
import net.minecraft.class_11630;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2960;

public class DebugHudClient implements ClientModInitializer {
	public static class_2960 ACTIVE_RENDERER = class_11631.method_72763(class_2960.method_60655("fabric", "active_renderer"), new ActiveRendererDebugHudEntry());

	@Override
	public void onInitializeClient() {
	}

	private static class ActiveRendererDebugHudEntry implements class_11632 {
		@Override
		public void method_72751(class_11630 lines, @Nullable class_1937 world, @Nullable class_2818 clientChunk, @Nullable class_2818 chunk) {
			lines.method_72747("[Fabric] Active renderer: " + Renderer.get().getClass().getSimpleName());
		}

		@Override
		public boolean method_72753(boolean reducedDebugInfo) {
			return true;
		}

		@Override
		public class_11605 method_72759() {
			return class_11605.field_61538;
		}
	}
}
