/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.model;

import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_773;
import net.minecraft.class_9891;

/**
 * Note: This interface is automatically implemented on {@link class_773} via Mixin and interface injection.
 */
public interface FabricBlockModels {
	/**
	 * Alternative for {@link class_773#method_3339(class_2680)} that additionally accepts a
	 * {@link class_1920} and {@link class_2338} to invoke
	 * {@link FabricBlockStateModel#particleSprite(class_1920, class_2338, class_2680)}. <b>Prefer using this method
	 * over the vanilla alternative when applicable to correctly retrieve context-aware particle sprites.</b> If world
	 * context is not available, use the vanilla method instead of passing empty world context to this method.
	 *
	 * @param state The block state whose model to retrieve the particle sprite from.
	 * @param blockView The world in which the block exists. <b>Should not be empty (i.e. not
	 * 	                {@link class_9891}).</b>
	 * @param pos The position of the block in the world.
	 * @return the particle sprite
	 */
	default class_1058 getModelParticleSprite(class_2680 state, class_1920 blockView, class_2338 pos) {
		return ((class_773) this).method_3335(state).particleSprite(blockView, pos, state);
	}
}
