/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.mesh;

import net.minecraft.class_1059;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;

/**
 * An atlas texture that a {@link QuadView} uses.
 */
public enum QuadAtlas {
	BLOCK(class_1059.field_5275),
	ITEM(class_1059.field_64467);

	private final class_2960 textureId;

	QuadAtlas(class_2960 textureId) {
		this.textureId = textureId;
	}

	/**
	 * {@return the quad atlas for the given atlas texture ID or null if no corresponding quad atlas exists}
	 */
	@Nullable
	public static QuadAtlas of(class_2960 atlasTextureId) {
		if (atlasTextureId.equals(class_1059.field_5275)) {
			return BLOCK;
		} else if (atlasTextureId.equals(class_1059.field_64467)) {
			return ITEM;
		} else {
			return null;
		}
	}

	/**
	 * {@return the atlas texture ID}
	 */
	public class_2960 getTextureId() {
		return textureId;
	}
}
