/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import net.minecraft.class_11515;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_4597;
import net.minecraft.class_4722;

public final class RenderLayerHelper {
	private RenderLayerHelper() {
	}

	/**
	 * Same logic as {@link net.minecraft.class_4696#method_29359}, but accepts a {@link class_11515} instead of a
	 * {@link class_2680}.
	 */
	public static class_1921 getMovingBlockLayer(class_11515 layer) {
		return switch (layer) {
		case field_60923 -> class_12249.method_75965();
		case field_60925 -> class_12249.method_75972();
		case field_60926 -> class_12249.method_75977();
		case field_60927 -> class_12249.method_76009();
		};
	}

	/**
	 * Same logic as {@link net.minecraft.class_4696#method_23683}, but accepts a {@link class_11515} instead of a
	 * {@link class_2680}.
	 */
	public static class_1921 getEntityBlockLayer(class_11515 layer) {
		return layer == class_11515.field_60926 ? class_4722.method_76545() : class_4722.method_24074();
	}

	/**
	 * Wraps the given provider, converting {@link class_11515}s to render layers using
	 * {@link #getMovingBlockLayer(class_11515)}.
	 */
	public static BlockVertexConsumerProvider movingDelegate(class_4597 vertexConsumers) {
		return layer -> vertexConsumers.method_73477(RenderLayerHelper.getMovingBlockLayer(layer));
	}

	/**
	 * Wraps the given provider, converting {@link class_11515}s to render layers using
	 * {@link #getEntityBlockLayer(class_11515)}.
	 */
	public static BlockVertexConsumerProvider entityDelegate(class_4597 vertexConsumers) {
		return layer -> vertexConsumers.method_73477(RenderLayerHelper.getEntityBlockLayer(layer));
	}
}
