/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import org.jspecify.annotations.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.minecraft.class_10444;
import net.minecraft.class_11515;
import net.minecraft.class_1921;

@FunctionalInterface
public interface ItemRenderTypeGetter {
	/**
	 * Gets the {@link class_1921} for the given {@link QuadAtlas} and nullable {@link class_11515}. Quads with
	 * matching property values will be rendered using the returned render type.
	 *
	 * <p>A return value of {@code null} means that the current item layer's
	 * {@linkplain class_10444.class_10446#method_67992(class_1921) default render type} will be used.
	 */
	@Nullable
	class_1921 renderType(QuadAtlas quadAtlas, @Nullable class_11515 sectionLayer);
}
