/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.render;

import java.util.Iterator;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.renderer.v1.render.FabricBlockModelRenderer;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.fabricmc.fabric.impl.renderer.BatchingRenderCommandQueueExtension;
import net.fabricmc.fabric.impl.renderer.DelegatingBlockVertexConsumerProviderImpl;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockCommand;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockStateModelCommand;
import net.minecraft.class_1087;
import net.minecraft.class_11661;
import net.minecraft.class_11681;
import net.minecraft.class_11788;
import net.minecraft.class_11791;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_776;

@Mixin(class_11681.class)
abstract class BlockFeatureRendererMixin {
	@Shadow
	@Final
	private class_4587 poseStack;

	// Support multi-render layer models (MovingBlockCommand).
	@Inject(method = "render", at = @At(value = "INVOKE", target = "Ljava/util/Iterator;hasNext()Z", ordinal = 0))
	private void beforeRenderMovingBlocks(class_11788 queue, class_4597.class_4598 vertexConsumers, class_776 blockRenderManager, class_4618 outlineVertexConsumers, CallbackInfo ci, @Local Iterator<class_11661.class_11790> iterator) {
		while (iterator.hasNext()) {
			class_11661.class_11790 command = iterator.next();
			class_11791 renderState = command.comp_4653();
			class_2680 blockState = renderState.field_62247;
			class_1087 model = blockRenderManager.method_3349(blockState);
			long seed = blockState.method_26190(renderState.field_62245);
			poseStack.method_22903();
			poseStack.method_34425(command.comp_4652());
			blockRenderManager.method_3350().render(renderState, model, blockState, renderState.field_62246, poseStack, RenderLayerHelper.movingDelegate(vertexConsumers), false, seed, class_4608.field_21444);
			poseStack.method_22909();
		}
	}

	// Support ExtendedBlockCommand and ExtendedBlockStateModelCommand.
	@Inject(method = "render", at = @At("RETURN"))
	private void onReturnRender(class_11788 queue, class_4597.class_4598 vertexConsumers, class_776 blockRenderManager, class_4618 outlineVertexConsumers, CallbackInfo ci) {
		DelegatingBlockVertexConsumerProviderImpl blockVertexConsumerProvider = new DelegatingBlockVertexConsumerProviderImpl();

		for (ExtendedBlockCommand command : ((BatchingRenderCommandQueueExtension) queue).fabric_getExtendedBlockCommands()) {
			poseStack.method_22903();
			poseStack.method_23760().method_66521(command.matricesEntry());
			blockRenderManager.renderBlockAsEntity(command.state(), poseStack, vertexConsumers, command.lightCoords(), command.overlayCoords(), command.blockView(), command.pos());

			if (command.outlineColor() != 0) {
				outlineVertexConsumers.method_23286(command.outlineColor());
				blockRenderManager.renderBlockAsEntity(command.state(), poseStack, outlineVertexConsumers, command.lightCoords(), command.overlayCoords(), command.blockView(), command.pos());
			}

			poseStack.method_22909();
		}

		for (ExtendedBlockStateModelCommand command : ((BatchingRenderCommandQueueExtension) queue).fabric_getExtendedBlockStateModelCommands()) {
			blockVertexConsumerProvider.renderLayerFunction = command.renderLayerFunction();
			blockVertexConsumerProvider.vertexConsumerProvider = vertexConsumers;
			FabricBlockModelRenderer.render(command.matricesEntry(), blockVertexConsumerProvider, command.model(), command.r(), command.g(), command.b(), command.lightCoords(), command.overlayCoords(), command.blockView(), command.pos(), command.state());

			if (command.outlineColor() != 0) {
				outlineVertexConsumers.method_23286(command.outlineColor());
				blockVertexConsumerProvider.vertexConsumerProvider = outlineVertexConsumers;
				FabricBlockModelRenderer.render(command.matricesEntry(), blockVertexConsumerProvider, command.model(), command.r(), command.g(), command.b(), command.lightCoords(), command.overlayCoords(), command.blockView(), command.pos(), command.state());
			}
		}
	}
}
