/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client.block.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.fabricmc.fabric.api.renderer.v1.render.FabricBlockModelRenderer;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.fabricmc.fabric.impl.renderer.BatchingRenderCommandQueueExtension;
import net.fabricmc.fabric.impl.renderer.DelegatingBlockVertexConsumerProviderImpl;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockCommand;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockStateModelCommand;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.MovingBlockRenderState;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.feature.BlockFeatureRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockFeatureRenderer.class})
abstract class BlockFeatureRendererMixin {
    @Shadow
    @Final
    private PoseStack poseStack;

    BlockFeatureRendererMixin() {
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=0)})
    private void beforeRenderMovingBlocks(SubmitNodeCollection queue, MultiBufferSource.BufferSource vertexConsumers, BlockRenderDispatcher blockRenderManager, OutlineBufferSource outlineVertexConsumers, CallbackInfo ci, @Local Iterator<SubmitNodeStorage.MovingBlockSubmit> iterator) {
        while (iterator.hasNext()) {
            SubmitNodeStorage.MovingBlockSubmit command = iterator.next();
            MovingBlockRenderState renderState = command.movingBlockRenderState();
            BlockState blockState = renderState.blockState;
            BlockStateModel model = blockRenderManager.getBlockModel(blockState);
            long seed = blockState.getSeed(renderState.randomSeedPos);
            this.poseStack.pushPose();
            this.poseStack.mulPose((Matrix4fc)command.pose());
            blockRenderManager.getModelRenderer().render((BlockAndTintGetter)renderState, model, blockState, renderState.blockPos, this.poseStack, RenderLayerHelper.movingDelegate((MultiBufferSource)vertexConsumers), false, seed, OverlayTexture.NO_OVERLAY);
            this.poseStack.popPose();
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onReturnRender(SubmitNodeCollection queue, MultiBufferSource.BufferSource vertexConsumers, BlockRenderDispatcher blockRenderManager, OutlineBufferSource outlineVertexConsumers, CallbackInfo ci) {
        DelegatingBlockVertexConsumerProviderImpl blockVertexConsumerProvider = new DelegatingBlockVertexConsumerProviderImpl();
        for (ExtendedBlockCommand extendedBlockCommand : ((BatchingRenderCommandQueueExtension)queue).fabric_getExtendedBlockCommands()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(extendedBlockCommand.matricesEntry());
            blockRenderManager.renderBlockAsEntity(extendedBlockCommand.state(), this.poseStack, (MultiBufferSource)vertexConsumers, extendedBlockCommand.lightCoords(), extendedBlockCommand.overlayCoords(), extendedBlockCommand.blockView(), extendedBlockCommand.pos());
            if (extendedBlockCommand.outlineColor() != 0) {
                outlineVertexConsumers.setColor(extendedBlockCommand.outlineColor());
                blockRenderManager.renderBlockAsEntity(extendedBlockCommand.state(), this.poseStack, (MultiBufferSource)outlineVertexConsumers, extendedBlockCommand.lightCoords(), extendedBlockCommand.overlayCoords(), extendedBlockCommand.blockView(), extendedBlockCommand.pos());
            }
            this.poseStack.popPose();
        }
        for (ExtendedBlockStateModelCommand extendedBlockStateModelCommand : ((BatchingRenderCommandQueueExtension)queue).fabric_getExtendedBlockStateModelCommands()) {
            blockVertexConsumerProvider.renderLayerFunction = extendedBlockStateModelCommand.renderLayerFunction();
            blockVertexConsumerProvider.vertexConsumerProvider = vertexConsumers;
            FabricBlockModelRenderer.render(extendedBlockStateModelCommand.matricesEntry(), blockVertexConsumerProvider, extendedBlockStateModelCommand.model(), extendedBlockStateModelCommand.r(), extendedBlockStateModelCommand.g(), extendedBlockStateModelCommand.b(), extendedBlockStateModelCommand.lightCoords(), extendedBlockStateModelCommand.overlayCoords(), extendedBlockStateModelCommand.blockView(), extendedBlockStateModelCommand.pos(), extendedBlockStateModelCommand.state());
            if (extendedBlockStateModelCommand.outlineColor() == 0) continue;
            outlineVertexConsumers.setColor(extendedBlockStateModelCommand.outlineColor());
            blockVertexConsumerProvider.vertexConsumerProvider = outlineVertexConsumers;
            FabricBlockModelRenderer.render(extendedBlockStateModelCommand.matricesEntry(), blockVertexConsumerProvider, extendedBlockStateModelCommand.model(), extendedBlockStateModelCommand.r(), extendedBlockStateModelCommand.g(), extendedBlockStateModelCommand.b(), extendedBlockStateModelCommand.lightCoords(), extendedBlockStateModelCommand.overlayCoords(), extendedBlockStateModelCommand.blockView(), extendedBlockStateModelCommand.pos(), extendedBlockStateModelCommand.state());
        }
    }
}

