/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.indigo.renderer.aocalc;

import static net.minecraft.util.math.Direction.*;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.indigo.renderer.mesh.QuadViewImpl;
import net.minecraft.class_156;
import net.minecraft.class_2350;

/**
 * Adapted from vanilla BlockModelRenderer.AoCalculator.
 */
@Environment(EnvType.CLIENT) 
enum AoFace {
    AOF_DOWN(new class_2350[]{field_11039, field_11034, field_11043, field_11035}, (q, i) -> q.y(i),
            (q, i, w) -> {
                final float u = q.x(i);
                final float v = q.z(i);
                w[0] = (1-u) * v; 
                w[1] = (1-u) * (1-v);
                w[2] = u * (1-v);
                w[3] = u * v;
            }),
    AOF_UP(new class_2350[]{field_11034, field_11039, field_11043, field_11035}, (q, i) -> 1 - q.y(i),
            (q, i, w) -> {
                final float u = q.x(i);
                final float v = q.z(i);
                w[0] = u * v; 
                w[1] = u * (1-v);
                w[2] = (1-u) * (1-v);
                w[3] = (1-u) * v;
            }), 
    AOF_NORTH(new class_2350[]{field_11036, field_11033, field_11034, field_11039}, (q, i) -> q.z(i),
            (q, i, w) -> {
                final float u = q.y(i);
                final float v = q.x(i);
                w[0] = u * (1-v);
                w[1] = u * v; 
                w[2] = (1-u) * v; 
                w[3] = (1-u) * (1-v);
            }), 
    AOF_SOUTH(new class_2350[]{field_11039, field_11034, field_11033, field_11036}, (q, i) -> 1 - q.z(i),
            (q, i, w) -> {
                final float u = q.y(i);
                final float v = q.x(i);
                w[0] = u * (1-v);
                w[1] = (1-u) * (1-v);
                w[2] = (1-u) * v;
                w[3] = u * v; 
            }), 
    AOF_WEST(new class_2350[]{field_11036, field_11033, field_11043, field_11035}, (q, i) -> q.x(i),
            (q, i, w) -> {
                final float u = q.y(i);
                final float v = q.z(i);
                w[0] = u * v; 
                w[1] = u * (1-v);
                w[2] = (1-u) * (1-v);
                w[3] = (1-u) * v;
            }), 
    AOF_EAST(new class_2350[]{field_11033, field_11036, field_11043, field_11035}, (q, i) -> 1 - q.x(i),
            (q, i, w) -> {
                final float u = q.y(i);
                final float v = q.z(i);
                w[0] = (1-u) * v; 
                w[1] = (1-u) * (1-v);
                w[2] = u * (1-v);
                w[3] = u * v;
            });

    final class_2350[] neighbors;
    final WeightFunction weightFunc;
    final Vertex2Float depthFunc;
    
    private AoFace(class_2350[] faces, Vertex2Float depthFunc, WeightFunction weightFunc) {
        this.neighbors = faces;
        this.depthFunc = depthFunc;
        this.weightFunc = weightFunc;
    }
    
    private static final AoFace[] values = (AoFace[])class_156.method_654(new AoFace[6], (neighborData) -> {
        neighborData[field_11033.method_10146()] = AOF_DOWN;
        neighborData[field_11036.method_10146()] = AOF_UP;
        neighborData[field_11043.method_10146()] = AOF_NORTH;
        neighborData[field_11035.method_10146()] = AOF_SOUTH;
        neighborData[field_11039.method_10146()] = AOF_WEST;
        neighborData[field_11034.method_10146()] = AOF_EAST;
    });

    public static AoFace get(class_2350 direction){
        return values[direction.method_10146()];
    }
    
    /**
     * Implementations handle bilinear interpolation of a point on a light face
     * by computing weights for each corner of the light face. Relies on the fact 
     * that each face is a unit cube. Uses coordinates from axes orthogonal to face
     * as distance from the edge of the cube, flipping as needed. Multiplying distance 
     * coordinate pairs together gives sub-area that are the corner weights. 
     * Weights sum to 1 because it is a unit cube. Values are stored in the provided array.
     */
    @FunctionalInterface
    static interface WeightFunction {
        void apply(QuadViewImpl q, int vertexIndex, float[] out);
    }

    @FunctionalInterface
    static interface Vertex2Float {
        float apply(QuadViewImpl q, int vertexIndex);
    }
}