/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.indigo.renderer.mixin;

import java.util.Random;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.indigo.renderer.render.BlockRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_324;
import net.minecraft.class_778;

@Mixin(class_778.class)
public abstract class MixinBlockModelRenderer {
    @Shadow protected class_324 colorMap;
    private final ThreadLocal<BlockRenderContext> CONTEXTS = ThreadLocal.withInitial(BlockRenderContext::new);
    
    @Inject(at = @At("HEAD"), method = "tesselate", cancellable = true)
    private void hookTesselate(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_287 buffer, boolean checkSides, Random rand, long seed, CallbackInfoReturnable<Boolean> ci) {
        if(!((FabricBakedModel)model).isVanillaAdapter()) {
            BlockRenderContext context = CONTEXTS.get();
            if(!context.isCallingVanilla()) {
                ci.setReturnValue(CONTEXTS.get().tesselate((class_778)(Object)this, blockView, model, state, pos, buffer, seed));
            }
        }
    }
}
