/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.indigo.renderer.render;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;

/**
 * Holds, manages and provides access to the block/world related state
 * needed by fallback and mesh consumers.<p>
 * 
 * Exception: per-block position offsets are tracked in {@link ChunkRenderInfo}
 * so they can be applied together with chunk offsets.
 */
public class BlockRenderInfo {
    private final class_324 blockColorMap = class_310.method_1551().method_1505();
    public final Random random = new Random();
    public class_1920 blockView;
    public class_2338 blockPos;
    public class_2680 blockState; 
    public long seed;
    boolean defaultAo;
    int defaultLayerIndex;
    
    public final Supplier<Random> randomSupplier = () -> {
        final Random result = random;
        long seed = this.seed;
        if(seed == -1L) {
            seed = blockState.method_11617(blockPos);
            this.seed = seed;
        }
        result.setSeed(seed);
        return result;
    };
    
    public void setBlockView(class_1920 blockView) {
        this.blockView = blockView;
    }
    
    public void prepareForBlock(class_2680 blockState, class_2338 blockPos, boolean modelAO) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        // in the unlikely case seed actually matches this, we'll simply retrieve it more than one
        seed = -1L; 
        defaultAo = modelAO && class_310.method_1588() && blockState.method_11630() == 0;
        defaultLayerIndex = blockState.method_11614().method_9551().ordinal();
    }
    
    public void release() {
        blockPos = null;
        blockState = null; 
    }
    
    int blockColor(int colorIndex) {
        return 0xFF000000 | blockColorMap.method_1697(blockState, blockView, blockPos, colorIndex);
    }
    
    boolean shouldDrawFace(class_2350 face) {
        return true;
    }
    
    int layerIndexOrDefault(class_1921 layer) {
        return layer == null ? this.defaultLayerIndex : layer.ordinal();
    }
}
