/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_1921;

public abstract class RenderMaterialImpl {
    private static final class_1921[] BLEND_MODES = class_1921.values();
    public static final int MAX_SPRITE_DEPTH = 1;
    private static final int TEXTURE_DEPTH_MASK = 3;
    private static final int TEXTURE_DEPTH_SHIFT = 0;
    private static final int BLEND_MODE_MASK = 3;
    private static final int[] BLEND_MODE_SHIFT = new int[3];
    private static final int[] COLOR_DISABLE_FLAGS = new int[3];
    private static final int[] EMISSIVE_FLAGS = new int[3];
    private static final int[] DIFFUSE_FLAGS = new int[3];
    private static final int[] AO_FLAGS = new int[3];
    private static final ObjectArrayList<Value> LIST;
    private static final Int2ObjectOpenHashMap<Value> MAP;
    protected int bits;

    public static Value byIndex(int index) {
        return (Value)LIST.get(index);
    }

    public class_1921 blendMode(int textureIndex) {
        return BLEND_MODES[this.bits >> BLEND_MODE_SHIFT[textureIndex] & 3];
    }

    public boolean disableColorIndex(int textureIndex) {
        return (this.bits & COLOR_DISABLE_FLAGS[textureIndex]) != 0;
    }

    public int spriteDepth() {
        return 1 + (this.bits >> 0 & 3);
    }

    public boolean emissive(int textureIndex) {
        return (this.bits & EMISSIVE_FLAGS[textureIndex]) != 0;
    }

    public boolean disableDiffuse(int textureIndex) {
        return (this.bits & DIFFUSE_FLAGS[textureIndex]) != 0;
    }

    public boolean disableAo(int textureIndex) {
        return (this.bits & AO_FLAGS[textureIndex]) != 0;
    }

    static {
        int shift = Integer.bitCount(3);
        for (int i = 0; i < 3; ++i) {
            RenderMaterialImpl.BLEND_MODE_SHIFT[i] = shift;
            shift += Integer.bitCount(3);
            RenderMaterialImpl.COLOR_DISABLE_FLAGS[i] = 1 << shift++;
            RenderMaterialImpl.EMISSIVE_FLAGS[i] = 1 << shift++;
            RenderMaterialImpl.DIFFUSE_FLAGS[i] = 1 << shift++;
            RenderMaterialImpl.AO_FLAGS[i] = 1 << shift++;
        }
        LIST = new ObjectArrayList();
        MAP = new Int2ObjectOpenHashMap();
    }

    public static class Finder
    extends RenderMaterialImpl
    implements MaterialFinder {
        public synchronized RenderMaterial find() {
            Value result = (Value)MAP.get(this.bits);
            if (result == null) {
                result = new Value(LIST.size(), this.bits);
                LIST.add((Object)result);
                MAP.put(this.bits, (Object)result);
            }
            return result;
        }

        public MaterialFinder clear() {
            this.bits = 0;
            return this;
        }

        public MaterialFinder blendMode(int textureIndex, class_1921 blendMode) {
            int shift = BLEND_MODE_SHIFT[textureIndex];
            this.bits = this.bits & ~(3 << shift) | blendMode.ordinal() << shift;
            return this;
        }

        public MaterialFinder disableColorIndex(int textureIndex, boolean disable) {
            int flag = COLOR_DISABLE_FLAGS[textureIndex];
            this.bits = disable ? this.bits | flag : this.bits & ~flag;
            return this;
        }

        public MaterialFinder spriteDepth(int depth) {
            if (depth < 1 || depth > 1) {
                throw new IndexOutOfBoundsException("Invalid sprite depth: " + depth);
            }
            this.bits = this.bits & 0xFFFFFFFC | --depth << 0;
            return this;
        }

        public MaterialFinder emissive(int textureIndex, boolean isEmissive) {
            int flag = EMISSIVE_FLAGS[textureIndex];
            this.bits = isEmissive ? this.bits | flag : this.bits & ~flag;
            return this;
        }

        public MaterialFinder disableDiffuse(int textureIndex, boolean disable) {
            int flag = DIFFUSE_FLAGS[textureIndex];
            this.bits = disable ? this.bits | flag : this.bits & ~flag;
            return this;
        }

        public MaterialFinder disableAo(int textureIndex, boolean disable) {
            int flag = AO_FLAGS[textureIndex];
            this.bits = disable ? this.bits | flag : this.bits & ~flag;
            return this;
        }
    }

    public static class Value
    extends RenderMaterialImpl
    implements RenderMaterial {
        private final int index;
        public final boolean hasAo;
        public final boolean hasEmissive;

        private Value(int index, int bits) {
            this.index = index;
            this.bits = bits;
            this.hasAo = !this.disableAo(0) || this.spriteDepth() > 1 && !this.disableAo(1) || this.spriteDepth() == 3 && !this.disableAo(2);
            this.hasEmissive = this.emissive(0) || this.emissive(1) || this.emissive(2);
        }

        public int index() {
            return this.index;
        }
    }
}

