/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.aocalc;

import java.util.function.ToIntBiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.indigo.renderer.aocalc.AoFace;
import net.fabricmc.indigo.renderer.aocalc.AoFaceData;
import net.fabricmc.indigo.renderer.aocalc.VanillaAoCalc;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.mesh.QuadViewImpl;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1160;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AoCalculator {
    private static final int[][] VERTEX_MAP = new int[6][4];
    private static final Logger LOGGER;
    private final VanillaAoCalc vanillaCalc;
    private final class_2338.class_2339 lightPos = new class_2338.class_2339();
    private final class_2338.class_2339 searchPos = new class_2338.class_2339();
    private final BlockRenderInfo blockInfo;
    private final ToIntBiFunction<class_2680, class_2338> brightnessFunc;
    private final AoFunc aoFunc;
    private final AoFaceData[] faceData = new AoFaceData[12];
    private int completionFlags = 0;
    private final float[] w = new float[4];
    public final float[] ao = new float[4];
    public final int[] light = new int[4];
    private static final boolean DEBUG;
    private static boolean fixSmoothLighting;
    AoFaceData tmpFace = new AoFaceData();
    private final class_1160 vertexNormal = new class_1160();

    public AoCalculator(BlockRenderInfo blockInfo, ToIntBiFunction<class_2680, class_2338> brightnessFunc, AoFunc aoFunc) {
        this.blockInfo = blockInfo;
        this.brightnessFunc = brightnessFunc;
        this.aoFunc = aoFunc;
        this.vanillaCalc = new VanillaAoCalc(brightnessFunc, aoFunc);
        for (int i = 0; i < 12; ++i) {
            this.faceData[i] = new AoFaceData();
        }
    }

    public void clear() {
        this.completionFlags = 0;
    }

    public void compute(MutableQuadViewImpl quad, boolean isVanilla) {
        AoConfig config = AoConfig.ENHANCED;
        boolean shouldMatch = false;
        switch (config) {
            case VANILLA: {
                this.calcVanilla(quad);
                break;
            }
            case EMULATE: {
                this.calcFastVanilla(quad);
                shouldMatch = DEBUG && isVanilla;
                break;
            }
            case HYBRID: {
                if (isVanilla) {
                    this.calcFastVanilla(quad);
                    break;
                }
            }
            default: {
                shouldMatch = this.calcEnhanced(quad);
            }
        }
        if (shouldMatch) {
            float[] vanillaAo = new float[4];
            int[] vanillaLight = new int[4];
            this.vanillaCalc.compute(this.blockInfo, quad, vanillaAo, vanillaLight);
            for (int i = 0; i < 4; ++i) {
                if (this.light[i] == vanillaLight[i] && class_3532.method_15347((float)this.ao[i], (float)vanillaAo[i])) continue;
                LOGGER.info(String.format("Mismatch for %s @ %s", this.blockInfo.blockState.toString(), this.blockInfo.blockPos.toString()));
                LOGGER.info(String.format("Flags = %d, LightFace = %s", quad.geometryFlags(), quad.lightFace().toString()));
                LOGGER.info(String.format("    Old Multiplier: %.2f, %.2f, %.2f, %.2f", Float.valueOf(vanillaAo[0]), Float.valueOf(vanillaAo[1]), Float.valueOf(vanillaAo[2]), Float.valueOf(vanillaAo[3])));
                LOGGER.info(String.format("    New Multiplier: %.2f, %.2f, %.2f, %.2f", Float.valueOf(this.ao[0]), Float.valueOf(this.ao[1]), Float.valueOf(this.ao[2]), Float.valueOf(this.ao[3])));
                LOGGER.info(String.format("    Old Brightness: %s, %s, %s, %s", Integer.toHexString(vanillaLight[0]), Integer.toHexString(vanillaLight[1]), Integer.toHexString(vanillaLight[2]), Integer.toHexString(vanillaLight[3])));
                LOGGER.info(String.format("    New Brightness: %s, %s, %s, %s", Integer.toHexString(this.light[0]), Integer.toHexString(this.light[1]), Integer.toHexString(this.light[2]), Integer.toHexString(this.light[3])));
                break;
            }
        }
    }

    private void calcVanilla(MutableQuadViewImpl quad) {
        this.vanillaCalc.compute(this.blockInfo, quad, this.ao, this.light);
    }

    private void calcFastVanilla(MutableQuadViewImpl quad) {
        int flags = quad.geometryFlags();
        if ((flags & 4) == 0 && class_2248.method_9614((class_265)this.blockInfo.blockState.method_11628((class_1922)this.blockInfo.blockView, this.blockInfo.blockPos))) {
            flags |= 4;
        }
        switch (flags) {
            case 7: {
                this.vanillaFullFace(quad, true);
                break;
            }
            case 6: {
                this.vanillaPartialFace(quad, true);
                break;
            }
            case 3: {
                this.vanillaFullFace(quad, false);
                break;
            }
            default: {
                this.vanillaPartialFace(quad, false);
            }
        }
    }

    private boolean calcEnhanced(MutableQuadViewImpl quad) {
        switch (quad.geometryFlags()) {
            case 7: {
                this.vanillaFullFace(quad, true);
                return DEBUG;
            }
            case 6: {
                this.vanillaPartialFace(quad, true);
                return DEBUG;
            }
            case 3: {
                this.blendedFullFace(quad);
                return false;
            }
            case 2: {
                this.blendedPartialFace(quad);
                return false;
            }
        }
        this.irregularFace(quad);
        return false;
    }

    private void vanillaFullFace(MutableQuadViewImpl quad, boolean isOnLightFace) {
        class_2350 lightFace = quad.lightFace();
        this.computeFace(lightFace, isOnLightFace).toArray(this.ao, this.light, VERTEX_MAP[lightFace.method_10146()]);
    }

    private void vanillaPartialFace(MutableQuadViewImpl quad, boolean isOnLightFace) {
        class_2350 lightFace = quad.lightFace();
        AoFaceData faceData = this.computeFace(lightFace, isOnLightFace);
        AoFace.WeightFunction wFunc = AoFace.get((class_2350)lightFace).weightFunc;
        float[] w = this.w;
        for (int i = 0; i < 4; ++i) {
            wFunc.apply(quad, i, w);
            this.light[i] = faceData.weightedCombinedLight(w);
            this.ao[i] = faceData.weigtedAo(w);
        }
    }

    private AoFaceData blendedInsetFace(QuadViewImpl quad, int vertexIndex, class_2350 lightFace) {
        float w1 = AoFace.get((class_2350)lightFace).depthFunc.apply(quad, vertexIndex);
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true), w0, this.computeFace(lightFace, false), w1, this.tmpFace);
    }

    private AoFaceData gatherInsetFace(QuadViewImpl quad, int vertexIndex, class_2350 lightFace) {
        float w1 = AoFace.get((class_2350)lightFace).depthFunc.apply(quad, vertexIndex);
        if (class_3532.method_15347((float)w1, (float)0.0f)) {
            return this.computeFace(lightFace, true);
        }
        if (class_3532.method_15347((float)w1, (float)1.0f)) {
            return this.computeFace(lightFace, false);
        }
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true), w0, this.computeFace(lightFace, false), w1, this.tmpFace);
    }

    private void blendedFullFace(MutableQuadViewImpl quad) {
        class_2350 lightFace = quad.lightFace();
        this.blendedInsetFace(quad, 0, lightFace).toArray(this.ao, this.light, VERTEX_MAP[lightFace.method_10146()]);
    }

    private void blendedPartialFace(MutableQuadViewImpl quad) {
        class_2350 lightFace = quad.lightFace();
        AoFaceData faceData = this.blendedInsetFace(quad, 0, lightFace);
        AoFace.WeightFunction wFunc = AoFace.get((class_2350)lightFace).weightFunc;
        for (int i = 0; i < 4; ++i) {
            wFunc.apply(quad, i, this.w);
            this.light[i] = faceData.weightedCombinedLight(this.w);
            this.ao[i] = faceData.weigtedAo(this.w);
        }
    }

    private void irregularFace(MutableQuadViewImpl quad) {
        class_1160 faceNorm = quad.faceNormal();
        float[] w = this.w;
        float[] aoResult = this.ao;
        int[] lightResult = this.light;
        for (int i = 0; i < 4; ++i) {
            float z;
            float y;
            class_1160 normal = quad.hasNormal(i) ? quad.copyNormal(i, this.vertexNormal) : faceNorm;
            float ao = 0.0f;
            float sky = 0.0f;
            float block = 0.0f;
            float maxAo = 0.0f;
            int maxSky = 0;
            int maxBlock = 0;
            float x = normal.method_4943();
            if (!class_3532.method_15347((float)0.0f, (float)x)) {
                class_2350 face = x > 0.0f ? class_2350.field_11034 : class_2350.field_11039;
                AoFaceData fd = this.gatherInsetFace(quad, i, face);
                AoFace.get((class_2350)face).weightFunc.apply(quad, i, w);
                float n = x * x;
                ao += n * fd.weigtedAo(w);
                sky += n * (float)fd.weigtedSkyLight(w);
                block += n * (float)fd.weigtedBlockLight(w);
                maxAo = fd.maxAo(maxAo);
                maxSky = fd.maxSkyLight(maxSky);
                maxBlock = fd.maxBlockLight(maxBlock);
            }
            if (!class_3532.method_15347((float)0.0f, (float)(y = normal.method_4945()))) {
                class_2350 face = y > 0.0f ? class_2350.field_11036 : class_2350.field_11033;
                AoFaceData fd = this.gatherInsetFace(quad, i, face);
                AoFace.get((class_2350)face).weightFunc.apply(quad, i, w);
                float n = y * y;
                ao += n * fd.weigtedAo(w);
                sky += n * (float)fd.weigtedSkyLight(w);
                block += n * (float)fd.weigtedBlockLight(w);
                maxAo = fd.maxAo(maxAo);
                maxSky = fd.maxSkyLight(maxSky);
                maxBlock = fd.maxBlockLight(maxBlock);
            }
            if (!class_3532.method_15347((float)0.0f, (float)(z = normal.method_4947()))) {
                class_2350 face = z > 0.0f ? class_2350.field_11035 : class_2350.field_11043;
                AoFaceData fd = this.gatherInsetFace(quad, i, face);
                AoFace.get((class_2350)face).weightFunc.apply(quad, i, w);
                float n = z * z;
                ao += n * fd.weigtedAo(w);
                sky += n * (float)fd.weigtedSkyLight(w);
                block += n * (float)fd.weigtedBlockLight(w);
                maxAo = fd.maxAo(maxAo);
                maxSky = fd.maxSkyLight(maxSky);
                maxBlock = fd.maxBlockLight(maxBlock);
            }
            aoResult[i] = (ao + maxAo) * 0.5f;
            lightResult[i] = ((int)((sky + (float)maxSky) * 0.5f) & 0xF0) << 16 | (int)((block + (float)maxBlock) * 0.5f) & 0xF0;
        }
    }

    private AoFaceData computeFace(class_2350 lightFace, boolean isOnBlockFace) {
        int faceDataIndex = isOnBlockFace ? lightFace.method_10146() : lightFace.method_10146() + 6;
        int mask = 1 << faceDataIndex;
        AoFaceData result = this.faceData[faceDataIndex];
        if ((this.completionFlags & mask) == 0) {
            int cLight3;
            float cAo3;
            int cLight2;
            float cAo2;
            int cLight1;
            float cAo1;
            int cLight0;
            float cAo0;
            boolean isClear3;
            this.completionFlags |= mask;
            class_1920 world = this.blockInfo.blockView;
            class_2680 blockState = this.blockInfo.blockState;
            class_2338 pos = this.blockInfo.blockPos;
            class_2338.class_2339 lightPos = this.lightPos;
            class_2338.class_2339 searchPos = this.searchPos;
            lightPos.method_10101((class_2382)(isOnBlockFace ? pos.method_10093(lightFace) : pos));
            AoFace aoFace = AoFace.get(lightFace);
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[0]);
            int light0 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            float ao0 = this.aoFunc.apply((class_2338)searchPos);
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[1]);
            int light1 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            float ao1 = this.aoFunc.apply((class_2338)searchPos);
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[2]);
            int light2 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            float ao2 = this.aoFunc.apply((class_2338)searchPos);
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[3]);
            int light3 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            float ao3 = this.aoFunc.apply((class_2338)searchPos);
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[0]);
            if (!fixSmoothLighting) {
                searchPos.method_10098(lightFace);
            }
            boolean isClear0 = world.method_8320((class_2338)searchPos).method_11581((class_1922)world, (class_2338)searchPos) == 0;
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[1]);
            if (!fixSmoothLighting) {
                searchPos.method_10098(lightFace);
            }
            boolean isClear1 = world.method_8320((class_2338)searchPos).method_11581((class_1922)world, (class_2338)searchPos) == 0;
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[2]);
            if (!fixSmoothLighting) {
                searchPos.method_10098(lightFace);
            }
            boolean isClear2 = world.method_8320((class_2338)searchPos).method_11581((class_1922)world, (class_2338)searchPos) == 0;
            searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[3]);
            if (!fixSmoothLighting) {
                searchPos.method_10098(lightFace);
            }
            boolean bl = isClear3 = world.method_8320((class_2338)searchPos).method_11581((class_1922)world, (class_2338)searchPos) == 0;
            if (!isClear2 && !isClear0) {
                cAo0 = ao0;
                cLight0 = light0;
            } else {
                searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[0]).method_10098(aoFace.neighbors[2]);
                cAo0 = this.aoFunc.apply((class_2338)searchPos);
                cLight0 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            }
            if (!isClear3 && !isClear0) {
                cAo1 = ao0;
                cLight1 = light0;
            } else {
                searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[0]).method_10098(aoFace.neighbors[3]);
                cAo1 = this.aoFunc.apply((class_2338)searchPos);
                cLight1 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            }
            if (!isClear2 && !isClear1) {
                cAo2 = ao1;
                cLight2 = light1;
            } else {
                searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[1]).method_10098(aoFace.neighbors[2]);
                cAo2 = this.aoFunc.apply((class_2338)searchPos);
                cLight2 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            }
            if (!isClear3 && !isClear1) {
                cAo3 = ao1;
                cLight3 = light1;
            } else {
                searchPos.method_10101((class_2382)lightPos).method_10098(aoFace.neighbors[1]).method_10098(aoFace.neighbors[3]);
                cAo3 = this.aoFunc.apply((class_2338)searchPos);
                cLight3 = this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos);
            }
            searchPos.method_10101((class_2382)pos).method_10098(lightFace);
            int lightCenter = isOnBlockFace || !world.method_8320((class_2338)searchPos).method_11598((class_1922)world, (class_2338)searchPos) ? this.brightnessFunc.applyAsInt(blockState, (class_2338)searchPos) : this.brightnessFunc.applyAsInt(blockState, pos);
            float aoCenter = this.aoFunc.apply((class_2338)(isOnBlockFace ? lightPos : pos));
            result.a0 = (ao3 + ao0 + cAo1 + aoCenter) * 0.25f;
            result.a1 = (ao2 + ao0 + cAo0 + aoCenter) * 0.25f;
            result.a2 = (ao2 + ao1 + cAo2 + aoCenter) * 0.25f;
            result.a3 = (ao3 + ao1 + cAo3 + aoCenter) * 0.25f;
            result.l0(AoCalculator.meanBrightness(light3, light0, cLight1, lightCenter));
            result.l1(AoCalculator.meanBrightness(light2, light0, cLight0, lightCenter));
            result.l2(AoCalculator.meanBrightness(light2, light1, cLight2, lightCenter));
            result.l3(AoCalculator.meanBrightness(light3, light1, cLight3, lightCenter));
        }
        return result;
    }

    private static int meanBrightness(int a, int b, int c, int d) {
        if (fixSmoothLighting) {
            return a == 0 || b == 0 || c == 0 || d == 0 ? AoCalculator.meanEdgeBrightness(a, b, c, d) : AoCalculator.meanInnerBrightness(a, b, c, d);
        }
        return AoCalculator.vanillaMeanBrightness(a, b, c, d);
    }

    private static int vanillaMeanBrightness(int a, int b, int c, int d) {
        if (a == 0) {
            a = d;
        }
        if (b == 0) {
            b = d;
        }
        if (c == 0) {
            c = d;
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int meanInnerBrightness(int a, int b, int c, int d) {
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int nonZeroMin(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    private static int meanEdgeBrightness(int a, int b, int c, int d) {
        int min = AoCalculator.nonZeroMin(AoCalculator.nonZeroMin(a, b), AoCalculator.nonZeroMin(c, d));
        return AoCalculator.meanInnerBrightness(Math.max(a, min), Math.max(b, min), Math.max(c, min), Math.max(d, min));
    }

    static {
        AoCalculator.VERTEX_MAP[class_2350.field_11033.method_10146()] = new int[]{0, 1, 2, 3};
        AoCalculator.VERTEX_MAP[class_2350.field_11036.method_10146()] = new int[]{2, 3, 0, 1};
        AoCalculator.VERTEX_MAP[class_2350.field_11043.method_10146()] = new int[]{3, 0, 1, 2};
        AoCalculator.VERTEX_MAP[class_2350.field_11035.method_10146()] = new int[]{0, 1, 2, 3};
        AoCalculator.VERTEX_MAP[class_2350.field_11039.method_10146()] = new int[]{3, 0, 1, 2};
        AoCalculator.VERTEX_MAP[class_2350.field_11034.method_10146()] = new int[]{1, 2, 3, 0};
        LOGGER = LogManager.getLogger();
        DEBUG = Boolean.valueOf(System.getProperty("fabric.debugAoLighting", "false"));
        fixSmoothLighting = true;
    }

    @FunctionalInterface
    public static interface AoFunc {
        public float apply(class_2338 var1);
    }
}

