/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.aocalc;

import java.util.BitSet;
import java.util.function.ToIntBiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_156;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public class VanillaAoCalc {
    private int[] vertexData = new int[28];
    private float[] aoBounds = new float[12];
    private final ToIntBiFunction<class_2680, class_2338> brightnessFunc;
    private final AoCalculator.AoFunc aoFunc;

    public VanillaAoCalc(ToIntBiFunction<class_2680, class_2338> brightnessFunc, AoCalculator.AoFunc aoFunc) {
        this.brightnessFunc = brightnessFunc;
        this.aoFunc = aoFunc;
    }

    public void compute(BlockRenderInfo blockInfo, QuadView quad, float[] ao, int[] brightness) {
        BitSet bits = new BitSet(3);
        quad.toVanilla(0, this.vertexData, 0, false);
        VanillaAoCalc.updateShape(blockInfo.blockView, blockInfo.blockState, blockInfo.blockPos, this.vertexData, quad.lightFace(), this.aoBounds, bits);
        this.apply(blockInfo.blockView, blockInfo.blockState, blockInfo.blockPos, quad.lightFace(), this.aoBounds, bits, ao, brightness);
    }

    private void apply(class_1920 blockView, class_2680 blockState, class_2338 blockPos, class_2350 side, float[] aoBounds, BitSet bits, float[] ao, int[] brightness) {
        int int_12;
        float float_12;
        int int_10;
        float float_10;
        int int_8;
        float float_8;
        int int_6;
        float float_6;
        boolean boolean_4;
        class_2338 lightPos = bits.get(0) ? blockPos.method_10093(side) : blockPos;
        NeighborData neighborData = NeighborData.getData(side);
        class_2338.class_2339 mpos = new class_2338.class_2339();
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[0]);
        int int_1 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        float float_1 = this.aoFunc.apply((class_2338)mpos);
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[1]);
        int int_2 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        float float_2 = this.aoFunc.apply((class_2338)mpos);
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[2]);
        int int_3 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        float float_3 = this.aoFunc.apply((class_2338)mpos);
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[3]);
        int int_4 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        float float_4 = this.aoFunc.apply((class_2338)mpos);
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[0]).method_10098(side);
        boolean boolean_1 = blockView.method_8320((class_2338)mpos).method_11581((class_1922)blockView, (class_2338)mpos) == 0;
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[1]).method_10098(side);
        boolean boolean_2 = blockView.method_8320((class_2338)mpos).method_11581((class_1922)blockView, (class_2338)mpos) == 0;
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[2]).method_10098(side);
        boolean boolean_3 = blockView.method_8320((class_2338)mpos).method_11581((class_1922)blockView, (class_2338)mpos) == 0;
        mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[3]).method_10098(side);
        boolean bl = boolean_4 = blockView.method_8320((class_2338)mpos).method_11581((class_1922)blockView, (class_2338)mpos) == 0;
        if (!boolean_3 && !boolean_1) {
            float_6 = float_1;
            int_6 = int_1;
        } else {
            mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[0]).method_10098(neighborData.faces[2]);
            float_6 = this.aoFunc.apply((class_2338)mpos);
            int_6 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        }
        if (!boolean_4 && !boolean_1) {
            float_8 = float_1;
            int_8 = int_1;
        } else {
            mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[0]).method_10098(neighborData.faces[3]);
            float_8 = this.aoFunc.apply((class_2338)mpos);
            int_8 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        }
        if (!boolean_3 && !boolean_2) {
            float_10 = float_2;
            int_10 = int_2;
        } else {
            mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[1]).method_10098(neighborData.faces[2]);
            float_10 = this.aoFunc.apply((class_2338)mpos);
            int_10 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        }
        if (!boolean_4 && !boolean_2) {
            float_12 = float_2;
            int_12 = int_2;
        } else {
            mpos.method_10101((class_2382)lightPos).method_10098(neighborData.faces[1]).method_10098(neighborData.faces[3]);
            float_12 = this.aoFunc.apply((class_2338)mpos);
            int_12 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        }
        int int_13 = this.brightnessFunc.applyAsInt(blockState, blockPos);
        mpos.method_10101((class_2382)blockPos).method_10098(side);
        if (bits.get(0) || !blockView.method_8320((class_2338)mpos).method_11598((class_1922)blockView, (class_2338)mpos)) {
            int_13 = this.brightnessFunc.applyAsInt(blockState, (class_2338)mpos);
        }
        float float_13 = bits.get(0) ? blockView.method_8320(lightPos).method_11596((class_1922)blockView, lightPos) : blockView.method_8320(blockPos).method_11596((class_1922)blockView, blockPos);
        Translation blockModelRenderer$Translation_1 = Translation.getTranslations(side);
        if (bits.get(1) && neighborData.nonCubicWeight) {
            float float_14 = (float_4 + float_1 + float_8 + float_13) * 0.25f;
            float float_15 = (float_3 + float_1 + float_6 + float_13) * 0.25f;
            float float_16 = (float_3 + float_2 + float_10 + float_13) * 0.25f;
            float float_17 = (float_4 + float_2 + float_12 + float_13) * 0.25f;
            float float_22 = aoBounds[neighborData.field_4192[0].shape] * aoBounds[neighborData.field_4192[1].shape];
            float float_23 = aoBounds[neighborData.field_4192[2].shape] * aoBounds[neighborData.field_4192[3].shape];
            float float_24 = aoBounds[neighborData.field_4192[4].shape] * aoBounds[neighborData.field_4192[5].shape];
            float float_25 = aoBounds[neighborData.field_4192[6].shape] * aoBounds[neighborData.field_4192[7].shape];
            float float_26 = aoBounds[neighborData.field_4185[0].shape] * aoBounds[neighborData.field_4185[1].shape];
            float float_27 = aoBounds[neighborData.field_4185[2].shape] * aoBounds[neighborData.field_4185[3].shape];
            float float_28 = aoBounds[neighborData.field_4185[4].shape] * aoBounds[neighborData.field_4185[5].shape];
            float float_29 = aoBounds[neighborData.field_4185[6].shape] * aoBounds[neighborData.field_4185[7].shape];
            float float_30 = aoBounds[neighborData.field_4180[0].shape] * aoBounds[neighborData.field_4180[1].shape];
            float float_31 = aoBounds[neighborData.field_4180[2].shape] * aoBounds[neighborData.field_4180[3].shape];
            float float_32 = aoBounds[neighborData.field_4180[4].shape] * aoBounds[neighborData.field_4180[5].shape];
            float float_33 = aoBounds[neighborData.field_4180[6].shape] * aoBounds[neighborData.field_4180[7].shape];
            float float_34 = aoBounds[neighborData.field_4188[0].shape] * aoBounds[neighborData.field_4188[1].shape];
            float float_35 = aoBounds[neighborData.field_4188[2].shape] * aoBounds[neighborData.field_4188[3].shape];
            float float_36 = aoBounds[neighborData.field_4188[4].shape] * aoBounds[neighborData.field_4188[5].shape];
            float float_37 = aoBounds[neighborData.field_4188[6].shape] * aoBounds[neighborData.field_4188[7].shape];
            ao[((Translation)blockModelRenderer$Translation_1).firstCorner] = float_14 * float_22 + float_15 * float_23 + float_16 * float_24 + float_17 * float_25;
            ao[((Translation)blockModelRenderer$Translation_1).secondCorner] = float_14 * float_26 + float_15 * float_27 + float_16 * float_28 + float_17 * float_29;
            ao[((Translation)blockModelRenderer$Translation_1).thirdCorner] = float_14 * float_30 + float_15 * float_31 + float_16 * float_32 + float_17 * float_33;
            ao[((Translation)blockModelRenderer$Translation_1).fourthCorner] = float_14 * float_34 + float_15 * float_35 + float_16 * float_36 + float_17 * float_37;
            int int_14 = this.getAmbientOcclusionBrightness(int_4, int_1, int_8, int_13);
            int int_15 = this.getAmbientOcclusionBrightness(int_3, int_1, int_6, int_13);
            int int_16 = this.getAmbientOcclusionBrightness(int_3, int_2, int_10, int_13);
            int int_17 = this.getAmbientOcclusionBrightness(int_4, int_2, int_12, int_13);
            brightness[((Translation)blockModelRenderer$Translation_1).firstCorner] = this.getBrightness(int_14, int_15, int_16, int_17, float_22, float_23, float_24, float_25);
            brightness[((Translation)blockModelRenderer$Translation_1).secondCorner] = this.getBrightness(int_14, int_15, int_16, int_17, float_26, float_27, float_28, float_29);
            brightness[((Translation)blockModelRenderer$Translation_1).thirdCorner] = this.getBrightness(int_14, int_15, int_16, int_17, float_30, float_31, float_32, float_33);
            brightness[((Translation)blockModelRenderer$Translation_1).fourthCorner] = this.getBrightness(int_14, int_15, int_16, int_17, float_34, float_35, float_36, float_37);
        } else {
            float float_14 = (float_4 + float_1 + float_8 + float_13) * 0.25f;
            float float_15 = (float_3 + float_1 + float_6 + float_13) * 0.25f;
            float float_16 = (float_3 + float_2 + float_10 + float_13) * 0.25f;
            float float_17 = (float_4 + float_2 + float_12 + float_13) * 0.25f;
            brightness[((Translation)blockModelRenderer$Translation_1).firstCorner] = this.getAmbientOcclusionBrightness(int_4, int_1, int_8, int_13);
            brightness[((Translation)blockModelRenderer$Translation_1).secondCorner] = this.getAmbientOcclusionBrightness(int_3, int_1, int_6, int_13);
            brightness[((Translation)blockModelRenderer$Translation_1).thirdCorner] = this.getAmbientOcclusionBrightness(int_3, int_2, int_10, int_13);
            brightness[((Translation)blockModelRenderer$Translation_1).fourthCorner] = this.getAmbientOcclusionBrightness(int_4, int_2, int_12, int_13);
            ao[((Translation)blockModelRenderer$Translation_1).firstCorner] = float_14;
            ao[((Translation)blockModelRenderer$Translation_1).secondCorner] = float_15;
            ao[((Translation)blockModelRenderer$Translation_1).thirdCorner] = float_16;
            ao[((Translation)blockModelRenderer$Translation_1).fourthCorner] = float_17;
        }
    }

    private int getAmbientOcclusionBrightness(int int_1, int int_2, int int_3, int int_4) {
        if (int_1 == 0) {
            int_1 = int_4;
        }
        if (int_2 == 0) {
            int_2 = int_4;
        }
        if (int_3 == 0) {
            int_3 = int_4;
        }
        return int_1 + int_2 + int_3 + int_4 >> 2 & 0xFF00FF;
    }

    private int getBrightness(int int_1, int int_2, int int_3, int int_4, float float_1, float float_2, float float_3, float float_4) {
        int int_5 = (int)((float)(int_1 >> 16 & 0xFF) * float_1 + (float)(int_2 >> 16 & 0xFF) * float_2 + (float)(int_3 >> 16 & 0xFF) * float_3 + (float)(int_4 >> 16 & 0xFF) * float_4) & 0xFF;
        int int_6 = (int)((float)(int_1 & 0xFF) * float_1 + (float)(int_2 & 0xFF) * float_2 + (float)(int_3 & 0xFF) * float_3 + (float)(int_4 & 0xFF) * float_4) & 0xFF;
        return int_5 << 16 | int_6;
    }

    public static void updateShape(class_1920 extendedBlockView_1, class_2680 blockState_1, class_2338 blockPos_1, int[] ints_1, class_2350 direction_1, float[] floats_1, BitSet bitSet_1) {
        float float_11;
        int int_2;
        float float_1 = 32.0f;
        float float_2 = 32.0f;
        float float_3 = 32.0f;
        float float_4 = -32.0f;
        float float_5 = -32.0f;
        float float_6 = -32.0f;
        for (int_2 = 0; int_2 < 4; ++int_2) {
            float_11 = Float.intBitsToFloat(ints_1[int_2 * 7]);
            float float_8 = Float.intBitsToFloat(ints_1[int_2 * 7 + 1]);
            float float_9 = Float.intBitsToFloat(ints_1[int_2 * 7 + 2]);
            float_1 = Math.min(float_1, float_11);
            float_2 = Math.min(float_2, float_8);
            float_3 = Math.min(float_3, float_9);
            float_4 = Math.max(float_4, float_11);
            float_5 = Math.max(float_5, float_8);
            float_6 = Math.max(float_6, float_9);
        }
        if (floats_1 != null) {
            floats_1[class_2350.field_11039.method_10146()] = float_1;
            floats_1[class_2350.field_11034.method_10146()] = float_4;
            floats_1[class_2350.field_11033.method_10146()] = float_2;
            floats_1[class_2350.field_11036.method_10146()] = float_5;
            floats_1[class_2350.field_11043.method_10146()] = float_3;
            floats_1[class_2350.field_11035.method_10146()] = float_6;
            int_2 = class_2350.values().length;
            floats_1[class_2350.field_11039.method_10146() + int_2] = 1.0f - float_1;
            floats_1[class_2350.field_11034.method_10146() + int_2] = 1.0f - float_4;
            floats_1[class_2350.field_11033.method_10146() + int_2] = 1.0f - float_2;
            floats_1[class_2350.field_11036.method_10146() + int_2] = 1.0f - float_5;
            floats_1[class_2350.field_11043.method_10146() + int_2] = 1.0f - float_3;
            floats_1[class_2350.field_11035.method_10146() + int_2] = 1.0f - float_6;
        }
        float_11 = 0.9999f;
        switch (direction_1) {
            case field_11033: {
                bitSet_1.set(1, float_1 >= 1.0E-4f || float_3 >= 1.0E-4f || float_4 <= 0.9999f || float_6 <= 0.9999f);
                bitSet_1.set(0, (float_2 < 1.0E-4f || class_2248.method_9614((class_265)blockState_1.method_11628((class_1922)extendedBlockView_1, blockPos_1))) && float_2 == float_5);
                break;
            }
            case field_11036: {
                bitSet_1.set(1, float_1 >= 1.0E-4f || float_3 >= 1.0E-4f || float_4 <= 0.9999f || float_6 <= 0.9999f);
                bitSet_1.set(0, (float_5 > 0.9999f || class_2248.method_9614((class_265)blockState_1.method_11628((class_1922)extendedBlockView_1, blockPos_1))) && float_2 == float_5);
                break;
            }
            case field_11043: {
                bitSet_1.set(1, float_1 >= 1.0E-4f || float_2 >= 1.0E-4f || float_4 <= 0.9999f || float_5 <= 0.9999f);
                bitSet_1.set(0, (float_3 < 1.0E-4f || class_2248.method_9614((class_265)blockState_1.method_11628((class_1922)extendedBlockView_1, blockPos_1))) && float_3 == float_6);
                break;
            }
            case field_11035: {
                bitSet_1.set(1, float_1 >= 1.0E-4f || float_2 >= 1.0E-4f || float_4 <= 0.9999f || float_5 <= 0.9999f);
                bitSet_1.set(0, (float_6 > 0.9999f || class_2248.method_9614((class_265)blockState_1.method_11628((class_1922)extendedBlockView_1, blockPos_1))) && float_3 == float_6);
                break;
            }
            case field_11039: {
                bitSet_1.set(1, float_2 >= 1.0E-4f || float_3 >= 1.0E-4f || float_5 <= 0.9999f || float_6 <= 0.9999f);
                bitSet_1.set(0, (float_1 < 1.0E-4f || class_2248.method_9614((class_265)blockState_1.method_11628((class_1922)extendedBlockView_1, blockPos_1))) && float_1 == float_4);
                break;
            }
            case field_11034: {
                bitSet_1.set(1, float_2 >= 1.0E-4f || float_3 >= 1.0E-4f || float_5 <= 0.9999f || float_6 <= 0.9999f);
                bitSet_1.set(0, (float_4 > 0.9999f || class_2248.method_9614((class_265)blockState_1.method_11628((class_1922)extendedBlockView_1, blockPos_1))) && float_1 == float_4);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum NeighborOrientation {
        DOWN(class_2350.field_11033, false),
        UP(class_2350.field_11036, false),
        NORTH(class_2350.field_11043, false),
        SOUTH(class_2350.field_11035, false),
        WEST(class_2350.field_11039, false),
        EAST(class_2350.field_11034, false),
        FLIP_DOWN(class_2350.field_11033, true),
        FLIP_UP(class_2350.field_11036, true),
        FLIP_NORTH(class_2350.field_11043, true),
        FLIP_SOUTH(class_2350.field_11035, true),
        FLIP_WEST(class_2350.field_11039, true),
        FLIP_EAST(class_2350.field_11034, true);

        private final int shape;

        private NeighborOrientation(class_2350 direction_1, boolean boolean_1) {
            this.shape = direction_1.method_10146() + (boolean_1 ? class_2350.values().length : 0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum NeighborData {
        DOWN(new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035}, 0.5f, true, new NeighborOrientation[]{NeighborOrientation.FLIP_WEST, NeighborOrientation.SOUTH, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.WEST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.WEST, NeighborOrientation.SOUTH}, new NeighborOrientation[]{NeighborOrientation.FLIP_WEST, NeighborOrientation.NORTH, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.WEST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.WEST, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.FLIP_EAST, NeighborOrientation.NORTH, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.EAST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.EAST, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.FLIP_EAST, NeighborOrientation.SOUTH, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.EAST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.EAST, NeighborOrientation.SOUTH}),
        UP(new class_2350[]{class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035}, 1.0f, true, new NeighborOrientation[]{NeighborOrientation.EAST, NeighborOrientation.SOUTH, NeighborOrientation.EAST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_EAST, NeighborOrientation.SOUTH}, new NeighborOrientation[]{NeighborOrientation.EAST, NeighborOrientation.NORTH, NeighborOrientation.EAST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_EAST, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.WEST, NeighborOrientation.NORTH, NeighborOrientation.WEST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_WEST, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.WEST, NeighborOrientation.SOUTH, NeighborOrientation.WEST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_WEST, NeighborOrientation.SOUTH}),
        NORTH(new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039}, 0.8f, true, new NeighborOrientation[]{NeighborOrientation.UP, NeighborOrientation.FLIP_WEST, NeighborOrientation.UP, NeighborOrientation.WEST, NeighborOrientation.FLIP_UP, NeighborOrientation.WEST, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_WEST}, new NeighborOrientation[]{NeighborOrientation.UP, NeighborOrientation.FLIP_EAST, NeighborOrientation.UP, NeighborOrientation.EAST, NeighborOrientation.FLIP_UP, NeighborOrientation.EAST, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_EAST}, new NeighborOrientation[]{NeighborOrientation.DOWN, NeighborOrientation.FLIP_EAST, NeighborOrientation.DOWN, NeighborOrientation.EAST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.EAST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_EAST}, new NeighborOrientation[]{NeighborOrientation.DOWN, NeighborOrientation.FLIP_WEST, NeighborOrientation.DOWN, NeighborOrientation.WEST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.WEST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_WEST}),
        SOUTH(new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036}, 0.8f, true, new NeighborOrientation[]{NeighborOrientation.UP, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_UP, NeighborOrientation.WEST, NeighborOrientation.UP, NeighborOrientation.WEST}, new NeighborOrientation[]{NeighborOrientation.DOWN, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_WEST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.WEST, NeighborOrientation.DOWN, NeighborOrientation.WEST}, new NeighborOrientation[]{NeighborOrientation.DOWN, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_DOWN, NeighborOrientation.EAST, NeighborOrientation.DOWN, NeighborOrientation.EAST}, new NeighborOrientation[]{NeighborOrientation.UP, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_EAST, NeighborOrientation.FLIP_UP, NeighborOrientation.EAST, NeighborOrientation.UP, NeighborOrientation.EAST}),
        WEST(new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035}, 0.6f, true, new NeighborOrientation[]{NeighborOrientation.UP, NeighborOrientation.SOUTH, NeighborOrientation.UP, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_UP, NeighborOrientation.SOUTH}, new NeighborOrientation[]{NeighborOrientation.UP, NeighborOrientation.NORTH, NeighborOrientation.UP, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_UP, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.DOWN, NeighborOrientation.NORTH, NeighborOrientation.DOWN, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_NORTH, NeighborOrientation.FLIP_DOWN, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.DOWN, NeighborOrientation.SOUTH, NeighborOrientation.DOWN, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.FLIP_DOWN, NeighborOrientation.SOUTH}),
        EAST(new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035}, 0.6f, true, new NeighborOrientation[]{NeighborOrientation.FLIP_DOWN, NeighborOrientation.SOUTH, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.DOWN, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.DOWN, NeighborOrientation.SOUTH}, new NeighborOrientation[]{NeighborOrientation.FLIP_DOWN, NeighborOrientation.NORTH, NeighborOrientation.FLIP_DOWN, NeighborOrientation.FLIP_NORTH, NeighborOrientation.DOWN, NeighborOrientation.FLIP_NORTH, NeighborOrientation.DOWN, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.FLIP_UP, NeighborOrientation.NORTH, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_NORTH, NeighborOrientation.UP, NeighborOrientation.FLIP_NORTH, NeighborOrientation.UP, NeighborOrientation.NORTH}, new NeighborOrientation[]{NeighborOrientation.FLIP_UP, NeighborOrientation.SOUTH, NeighborOrientation.FLIP_UP, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.UP, NeighborOrientation.FLIP_SOUTH, NeighborOrientation.UP, NeighborOrientation.SOUTH});

        private final class_2350[] faces;
        private final boolean nonCubicWeight;
        private final NeighborOrientation[] field_4192;
        private final NeighborOrientation[] field_4185;
        private final NeighborOrientation[] field_4180;
        private final NeighborOrientation[] field_4188;
        private static final NeighborData[] field_4190;

        private NeighborData(class_2350[] directions_1, float float_1, boolean boolean_1, NeighborOrientation[] blockModelRenderer$NeighborOrientations_1, NeighborOrientation[] blockModelRenderer$NeighborOrientations_2, NeighborOrientation[] blockModelRenderer$NeighborOrientations_3, NeighborOrientation[] blockModelRenderer$NeighborOrientations_4) {
            this.faces = directions_1;
            this.nonCubicWeight = boolean_1;
            this.field_4192 = blockModelRenderer$NeighborOrientations_1;
            this.field_4185 = blockModelRenderer$NeighborOrientations_2;
            this.field_4180 = blockModelRenderer$NeighborOrientations_3;
            this.field_4188 = blockModelRenderer$NeighborOrientations_4;
        }

        public static NeighborData getData(class_2350 direction_1) {
            return field_4190[direction_1.method_10146()];
        }

        static {
            field_4190 = (NeighborData[])class_156.method_654((Object)new NeighborData[6], blockModelRenderer$NeighborDatas_1 -> {
                blockModelRenderer$NeighborDatas_1[class_2350.field_11033.method_10146()] = DOWN;
                blockModelRenderer$NeighborDatas_1[class_2350.field_11036.method_10146()] = UP;
                blockModelRenderer$NeighborDatas_1[class_2350.field_11043.method_10146()] = NORTH;
                blockModelRenderer$NeighborDatas_1[class_2350.field_11035.method_10146()] = SOUTH;
                blockModelRenderer$NeighborDatas_1[class_2350.field_11039.method_10146()] = WEST;
                blockModelRenderer$NeighborDatas_1[class_2350.field_11034.method_10146()] = EAST;
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    static enum Translation {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int firstCorner;
        private final int secondCorner;
        private final int thirdCorner;
        private final int fourthCorner;
        private static final Translation[] VALUES;

        private Translation(int int_1, int int_2, int int_3, int int_4) {
            this.firstCorner = int_1;
            this.secondCorner = int_2;
            this.thirdCorner = int_3;
            this.fourthCorner = int_4;
        }

        public static Translation getTranslations(class_2350 direction_1) {
            return VALUES[direction_1.method_10146()];
        }

        static {
            VALUES = (Translation[])class_156.method_654((Object)new Translation[6], blockModelRenderer$Translations_1 -> {
                blockModelRenderer$Translations_1[class_2350.field_11033.method_10146()] = DOWN;
                blockModelRenderer$Translations_1[class_2350.field_11036.method_10146()] = UP;
                blockModelRenderer$Translations_1[class_2350.field_11043.method_10146()] = NORTH;
                blockModelRenderer$Translations_1[class_2350.field_11035.method_10146()] = SOUTH;
                blockModelRenderer$Translations_1[class_2350.field_11039.method_10146()] = WEST;
                blockModelRenderer$Translations_1[class_2350.field_11034.method_10146()] = EAST;
            });
        }
    }
}

