/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.helper;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.nio.ByteOrder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.minecraft.class_1160;
import net.minecraft.class_2350;

public abstract class ColorHelper {
    private static final float[] FACE_SHADE_FACTORS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    private static final Int2IntFunction colorSwapper = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? color -> color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16 : color -> color;
    private static VertexLighter[] VERTEX_LIGHTERS = new VertexLighter[8];

    private ColorHelper() {
    }

    public static int swapRedBlueIfNeeded(int color) {
        return colorSwapper.applyAsInt(color);
    }

    public static int multiplyColor(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        if (color2 == -1) {
            return color1;
        }
        int alpha = (color1 >> 24 & 0xFF) * (color2 >> 24 & 0xFF) / 255;
        int red = (color1 >> 16 & 0xFF) * (color2 >> 16 & 0xFF) / 255;
        int green = (color1 >> 8 & 0xFF) * (color2 >> 8 & 0xFF) / 255;
        int blue = (color1 & 0xFF) * (color2 & 0xFF) / 255;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int multiplyRGB(int color, float shade) {
        int alpha = color >> 24 & 0xFF;
        int red = (int)((float)(color >> 16 & 0xFF) * shade);
        int green = (int)((float)(color >> 8 & 0xFF) * shade);
        int blue = (int)((float)(color & 0xFF) * shade);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static float diffuseShade(class_2350 direction) {
        return FACE_SHADE_FACTORS[direction.method_10146()];
    }

    public static float normalShade(float normalX, float normalY, float normalZ) {
        return Math.min(0.5f + Math.abs(normalX) * 0.1f + (normalY > 0.0f ? 0.5f * normalY : 0.0f) + Math.abs(normalZ) * 0.3f, 1.0f);
    }

    public static float normalShade(class_1160 normal) {
        return ColorHelper.normalShade(normal.method_4943(), normal.method_4945(), normal.method_4947());
    }

    public static float vertexShade(ShadeableQuad q, int vertexIndex, float faceShade) {
        return q.hasNormal(vertexIndex) ? ColorHelper.normalShade(q.normalX(vertexIndex), q.normalY(vertexIndex), q.normalZ(vertexIndex)) : faceShade;
    }

    public static float faceShade(ShadeableQuad quad) {
        return quad.isFaceAligned() ? ColorHelper.diffuseShade(quad.lightFace()) : ColorHelper.normalShade(quad.faceNormal());
    }

    public static void applyDiffuseShading(ShadeableQuad quad, boolean undo) {
        int i;
        float faceShade = ColorHelper.faceShade(quad);
        int n = i = quad.needsDiffuseShading(0) ? 1 : 0;
        if (quad.needsDiffuseShading(1)) {
            i |= 2;
        }
        if (quad.needsDiffuseShading(2)) {
            i |= 4;
        }
        if (i == 0) {
            return;
        }
        VertexLighter shader = VERTEX_LIGHTERS[i];
        for (int j = 0; j < 4; ++j) {
            float vertexShade = ColorHelper.vertexShade(quad, j, faceShade);
            shader.shade(quad, j, undo ? 1.0f / vertexShade : vertexShade);
        }
    }

    public static int maxBrightness(int b0, int b1) {
        if (b0 == 0) {
            return b1;
        }
        if (b1 == 0) {
            return b0;
        }
        return Math.max(b0 & 0xFFFF, b1 & 0xFFFF) | Math.max(b0 & 0xFFFF0000, b1 & 0xFFFF0000);
    }

    static {
        ColorHelper.VERTEX_LIGHTERS[0] = (q, i, s) -> {};
        ColorHelper.VERTEX_LIGHTERS[1] = (q, i, s) -> q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), s));
        ColorHelper.VERTEX_LIGHTERS[2] = (q, i, s) -> q.spriteColor(i, 1, ColorHelper.multiplyRGB(q.spriteColor(i, 1), s));
        ColorHelper.VERTEX_LIGHTERS[3] = (q, i, s) -> q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), s)).spriteColor(i, 1, ColorHelper.multiplyRGB(q.spriteColor(i, 1), s));
        ColorHelper.VERTEX_LIGHTERS[4] = (q, i, s) -> q.spriteColor(i, 2, ColorHelper.multiplyRGB(q.spriteColor(i, 2), s));
        ColorHelper.VERTEX_LIGHTERS[5] = (q, i, s) -> q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), s)).spriteColor(i, 2, ColorHelper.multiplyRGB(q.spriteColor(i, 2), s));
        ColorHelper.VERTEX_LIGHTERS[6] = (q, i, s) -> q.spriteColor(i, 1, ColorHelper.multiplyRGB(q.spriteColor(i, 1), s)).spriteColor(i, 2, ColorHelper.multiplyRGB(q.spriteColor(i, 2), s));
        ColorHelper.VERTEX_LIGHTERS[7] = (q, i, s) -> q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), s)).spriteColor(i, 1, ColorHelper.multiplyRGB(q.spriteColor(i, 1), s)).spriteColor(i, 2, ColorHelper.multiplyRGB(q.spriteColor(i, 2), s));
    }

    @FunctionalInterface
    private static interface VertexLighter {
        public void shade(ShadeableQuad var1, int var2, float var3);
    }

    public static interface ShadeableQuad
    extends MutableQuadView {
        public boolean isFaceAligned();

        public boolean needsDiffuseShading(int var1);
    }
}

