/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.mesh;

import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.minecraft.class_2350;

public abstract class EncodingFormat {
    static final int HEADER_MATERIAL = 0;
    static final int HEADER_COLOR_INDEX = 1;
    static final int HEADER_BITS = 2;
    static final int HEADER_TAG = 3;
    public static final int HEADER_STRIDE = 4;
    public static final int VERTEX_START_OFFSET = 4;
    static final int VANILLA_STRIDE = 28;
    public static final int NORMALS_OFFSET = 32;
    static final int NORMALS_STRIDE = 4;
    static final int TEXTURE_STRIDE = 12;
    static final int TEXTURE_OFFSET_MINUS = 24;
    static final int SECOND_TEXTURE_OFFSET = 36;
    static final int THIRD_TEXTURE_OFFSET = 48;
    public static final int MAX_STRIDE = 36;
    static final int[] EMPTY = new int[36];
    private static final int DIRECTION_MASK = 7;
    private static final int CULL_SHIFT = 0;
    private static final int CULL_INVERSE_MASK = -8;
    private static final int LIGHT_SHIFT = 0 + Integer.bitCount(7);
    private static final int LIGHT_INVERSE_MASK = ~(7 << LIGHT_SHIFT);
    private static final int NORMALS_SHIFT = LIGHT_SHIFT + Integer.bitCount(7);
    private static final int NORMALS_MASK = 15;
    private static final int NORMALS_INVERSE_MASK = ~(15 << NORMALS_SHIFT);
    private static final int GEOMETRY_SHIFT = NORMALS_SHIFT + Integer.bitCount(15);
    private static final int GEOMETRY_MASK = 7;
    private static final int GEOMETRY_INVERSE_MASK = ~(7 << GEOMETRY_SHIFT);

    private EncodingFormat() {
    }

    static class_2350 cullFace(int bits) {
        return ModelHelper.faceFromIndex((int)(bits >> 0 & 7));
    }

    static int cullFace(int bits, class_2350 face) {
        return bits & 0xFFFFFFF8 | ModelHelper.toFaceIndex((class_2350)face) << 0;
    }

    static class_2350 lightFace(int bits) {
        return ModelHelper.faceFromIndex((int)(bits >> LIGHT_SHIFT & 7));
    }

    static int lightFace(int bits, class_2350 face) {
        return bits & LIGHT_INVERSE_MASK | ModelHelper.toFaceIndex((class_2350)face) << LIGHT_SHIFT;
    }

    static int normalFlags(int bits) {
        return bits >> NORMALS_SHIFT & 0xF;
    }

    static int normalFlags(int bits, int normalFlags) {
        return bits & NORMALS_INVERSE_MASK | (normalFlags & 0xF) << NORMALS_SHIFT;
    }

    public static int stride(int textureDepth) {
        return 24 + textureDepth * 12;
    }

    static int geometryFlags(int bits) {
        return bits >> GEOMETRY_SHIFT;
    }

    static int geometryFlags(int bits, int geometryFlags) {
        return bits & GEOMETRY_INVERSE_MASK | (geometryFlags & 7) << GEOMETRY_SHIFT;
    }
}

