/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.mesh;

import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.indigo.renderer.helper.ColorHelper;
import net.fabricmc.indigo.renderer.helper.GeometryHelper;
import net.fabricmc.indigo.renderer.mesh.MeshImpl;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;

public class MeshBuilderImpl
implements MeshBuilder {
    int[] data = new int[256];
    private final Maker maker = new Maker();
    int index = 0;
    int limit = this.data.length;

    protected void ensureCapacity(int stride) {
        if (stride > this.limit - this.index) {
            this.limit *= 2;
            int[] bigger = new int[this.limit];
            System.arraycopy(this.data, 0, bigger, 0, this.index);
            this.data = bigger;
            this.maker.data = bigger;
        }
    }

    public Mesh build() {
        int[] packed = new int[this.index];
        System.arraycopy(this.data, 0, packed, 0, this.index);
        this.index = 0;
        return new MeshImpl(packed);
    }

    public QuadEmitter getEmitter() {
        this.ensureCapacity(36);
        this.maker.begin(this.data, this.index);
        return this.maker;
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
        }

        public Maker emit() {
            this.lightFace = GeometryHelper.lightFace(this);
            this.geometryFlags = GeometryHelper.computeShapeFlags(this);
            ColorHelper.applyDiffuseShading(this, false);
            this.encodeHeader();
            MeshBuilderImpl.this.index += MeshBuilderImpl.this.maker.stride();
            MeshBuilderImpl.this.ensureCapacity(36);
            this.baseIndex = MeshBuilderImpl.this.index;
            this.clear();
            return this;
        }
    }
}

