/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.mesh;

import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.indigo.renderer.IndigoRenderer;
import net.fabricmc.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.indigo.renderer.helper.ColorHelper;
import net.fabricmc.indigo.renderer.helper.NormalHelper;
import net.fabricmc.indigo.renderer.helper.TextureHelper;
import net.fabricmc.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.indigo.renderer.mesh.QuadViewImpl;
import net.minecraft.class_1058;
import net.minecraft.class_2350;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements QuadEmitter,
ColorHelper.ShadeableQuad {
    public final void begin(int[] data, int baseIndex) {
        this.data = data;
        this.baseIndex = baseIndex;
        this.clear();
    }

    public void clear() {
        System.arraycopy(EncodingFormat.EMPTY, 0, this.data, this.baseIndex, 36);
        this.isFaceNormalInvalid = true;
        this.isGeometryInvalid = true;
        this.normalFlags = 0;
        this.tag = 0;
        this.colorIndex = -1;
        this.cullFace = null;
        this.lightFace = null;
        this.nominalFace = null;
        this.material = IndigoRenderer.MATERIAL_STANDARD;
    }

    public final MutableQuadViewImpl material(RenderMaterial material) {
        if (material == null || material.spriteDepth() > this.material.spriteDepth()) {
            throw new UnsupportedOperationException("Material texture depth must be the same or less than original material.");
        }
        this.material = (RenderMaterialImpl.Value)material;
        return this;
    }

    public final MutableQuadViewImpl cullFace(class_2350 face) {
        this.cullFace = face;
        this.nominalFace = face;
        return this;
    }

    public final MutableQuadViewImpl lightFace(class_2350 face) {
        this.lightFace = face;
        return this;
    }

    public final MutableQuadViewImpl nominalFace(class_2350 face) {
        this.nominalFace = face;
        return this;
    }

    public final MutableQuadViewImpl colorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
        return this;
    }

    public final MutableQuadViewImpl tag(int tag) {
        this.tag = tag;
        return this;
    }

    public final MutableQuadViewImpl fromVanilla(int[] quadData, int startIndex, boolean isItem) {
        int vertexStart = this.vertexStart();
        if (isItem) {
            System.arraycopy(quadData, startIndex, this.data, vertexStart, 6);
            System.arraycopy(quadData, startIndex + 7, this.data, vertexStart + 7, 6);
            System.arraycopy(quadData, startIndex + 14, this.data, vertexStart + 14, 6);
            System.arraycopy(quadData, startIndex + 21, this.data, vertexStart + 21, 6);
            int normalsIndex = this.baseIndex + 32;
            this.data[normalsIndex] = quadData[startIndex + 6];
            this.data[normalsIndex + 1] = quadData[startIndex + 13];
            this.data[normalsIndex + 2] = quadData[startIndex + 20];
            this.data[normalsIndex + 3] = quadData[startIndex + 27];
        } else {
            System.arraycopy(quadData, startIndex, this.data, vertexStart, 28);
        }
        this.invalidateShape();
        return this;
    }

    @Override
    public boolean isFaceAligned() {
        return (this.geometryFlags() & 2) != 0;
    }

    @Override
    public boolean needsDiffuseShading(int textureIndex) {
        return textureIndex < this.material.spriteDepth() && !this.material.disableDiffuse(textureIndex);
    }

    public MutableQuadViewImpl pos(int vertexIndex, float x, float y, float z) {
        int index = this.vertexStart() + vertexIndex * 7;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isFaceNormalInvalid = true;
        return this;
    }

    public MutableQuadViewImpl normal(int vertexIndex, float x, float y, float z) {
        this.normalFlags |= 1 << vertexIndex;
        this.data[this.baseIndex + 4 + 28 + vertexIndex] = NormalHelper.packNormal(x, y, z, 0.0f);
        return this;
    }

    public MutableQuadViewImpl lightmap(int vertexIndex, int lightmap) {
        this.data[this.baseIndex + vertexIndex * 7 + 6 + 4] = lightmap;
        return this;
    }

    public MutableQuadViewImpl spriteColor(int vertexIndex, int textureIndex, int color) {
        this.data[this.baseIndex + this.colorIndex((int)vertexIndex, (int)textureIndex)] = color;
        return this;
    }

    public MutableQuadViewImpl sprite(int vertexIndex, int textureIndex, float u, float v) {
        int i = this.baseIndex + this.colorIndex(vertexIndex, textureIndex) + 1;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public MutableQuadViewImpl spriteBake(int spriteIndex, class_1058 sprite, int bakeFlags) {
        TextureHelper.bakeSprite(this, spriteIndex, sprite, bakeFlags);
        return this;
    }
}

