/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.mesh;

import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.indigo.renderer.helper.GeometryHelper;
import net.fabricmc.indigo.renderer.helper.NormalHelper;
import net.fabricmc.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.minecraft.class_1160;
import net.minecraft.class_2350;

public class QuadViewImpl
implements QuadView {
    protected RenderMaterialImpl.Value material;
    protected class_2350 cullFace;
    protected class_2350 nominalFace;
    protected class_2350 lightFace;
    protected int colorIndex = -1;
    protected int tag = 0;
    protected int normalFlags;
    protected int geometryFlags;
    protected boolean isGeometryInvalid = true;
    protected final class_1160 faceNormal = new class_1160();
    protected boolean isFaceNormalInvalid = true;
    protected int[] data;
    protected int baseIndex = 0;

    final void load(int[] data, int baseIndex) {
        this.data = data;
        this.baseIndex = baseIndex;
        this.load();
    }

    public final void invalidateShape() {
        this.isFaceNormalInvalid = true;
        this.isGeometryInvalid = true;
    }

    public final void load() {
        this.isFaceNormalInvalid = true;
        this.isGeometryInvalid = false;
        this.decodeHeader();
    }

    public int[] data() {
        return this.data;
    }

    public boolean hasVertexNormals() {
        return this.normalFlags != 0;
    }

    public int vertexStart() {
        return this.baseIndex + 4;
    }

    final int stride() {
        return EncodingFormat.stride(this.material.spriteDepth());
    }

    protected void decodeHeader() {
        this.material = RenderMaterialImpl.byIndex(this.data[this.baseIndex + 0]);
        int bits = this.data[this.baseIndex + 2];
        this.colorIndex = this.data[this.baseIndex + 1];
        this.tag = this.data[this.baseIndex + 3];
        this.geometryFlags = EncodingFormat.geometryFlags(bits);
        this.cullFace = EncodingFormat.cullFace(bits);
        this.nominalFace = this.lightFace = EncodingFormat.lightFace(bits);
        this.normalFlags = EncodingFormat.normalFlags(bits);
    }

    protected void encodeHeader() {
        this.data[this.baseIndex + 0] = this.material.index();
        this.data[this.baseIndex + 1] = this.colorIndex;
        this.data[this.baseIndex + 3] = this.tag;
        int bits = EncodingFormat.geometryFlags(0, this.geometryFlags);
        bits = EncodingFormat.normalFlags(bits, this.normalFlags);
        bits = EncodingFormat.cullFace(bits, this.cullFace);
        this.data[this.baseIndex + 2] = bits = EncodingFormat.lightFace(bits, this.lightFace);
    }

    public int geometryFlags() {
        if (this.isGeometryInvalid) {
            this.isGeometryInvalid = false;
            this.geometryFlags = GeometryHelper.computeShapeFlags(this);
        }
        return this.geometryFlags;
    }

    public void geometryFlags(int flags) {
        this.isGeometryInvalid = false;
        this.geometryFlags = flags;
    }

    public final void toVanilla(int textureIndex, int[] target, int targetIndex, boolean isItem) {
        System.arraycopy(this.data, this.vertexStart(), target, targetIndex, 28);
        if (textureIndex > 0) {
            this.copyColorUV(textureIndex, target, targetIndex);
        }
        if (isItem) {
            this.copyNormals(target, targetIndex);
        }
    }

    public final void copyColorUV(int textureIndex, int[] target, int targetIndex) {
        int strideFrom;
        int indexFrom;
        int indexTo = targetIndex + 3;
        if (textureIndex == 0) {
            indexFrom = this.baseIndex + 4 + 3;
            strideFrom = 7;
        } else {
            indexFrom = this.baseIndex + (textureIndex == 1 ? 36 : 48);
            strideFrom = 3;
        }
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.data, indexFrom, target, indexTo, 3);
            indexTo += 7;
            indexFrom += strideFrom;
        }
    }

    public final void copyNormals(int[] target, int targetIndex) {
        int normalFlags = this.normalFlags;
        int packedFaceNormal = normalFlags == 15 ? 0 : NormalHelper.packNormal(this.faceNormal(), 0.0f);
        int normalsIndex = this.baseIndex + 32;
        for (int v = 0; v < 4; ++v) {
            int packed;
            target[targetIndex + v * 7 + 6] = packed = (normalFlags & 1 << v) == 0 ? packedFaceNormal : this.data[normalsIndex + v];
        }
    }

    public final RenderMaterialImpl.Value material() {
        return this.material;
    }

    public final int colorIndex() {
        return this.colorIndex;
    }

    public final int tag() {
        return this.tag;
    }

    public final class_2350 lightFace() {
        return this.lightFace;
    }

    public final class_2350 cullFace() {
        return this.cullFace;
    }

    public final class_2350 nominalFace() {
        return this.nominalFace;
    }

    public final class_1160 faceNormal() {
        if (this.isFaceNormalInvalid) {
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.isFaceNormalInvalid = false;
        }
        return this.faceNormal;
    }

    public void copyTo(MutableQuadView target) {
        MutableQuadViewImpl quad = (MutableQuadViewImpl)target;
        int len = Math.min(this.stride(), quad.stride());
        System.arraycopy(this.data, this.baseIndex + 1, quad.data, quad.baseIndex + 1, len - 1);
        quad.isFaceNormalInvalid = this.isFaceNormalInvalid;
        if (!this.isFaceNormalInvalid) {
            quad.faceNormal.method_4949(this.faceNormal.method_4943(), this.faceNormal.method_4945(), this.faceNormal.method_4947());
        }
        quad.lightFace = this.lightFace;
        quad.colorIndex = this.colorIndex;
        quad.tag = this.tag;
        quad.cullFace = this.cullFace;
        quad.nominalFace = this.nominalFace;
        quad.normalFlags = this.normalFlags;
    }

    public class_1160 copyPos(int vertexIndex, class_1160 target) {
        if (target == null) {
            target = new class_1160();
        }
        int index = this.vertexStart() + vertexIndex * 7;
        target.method_4949(Float.intBitsToFloat(this.data[index]), Float.intBitsToFloat(this.data[index + 1]), Float.intBitsToFloat(this.data[index + 2]));
        return target;
    }

    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[this.vertexStart() + vertexIndex * 7 + coordinateIndex]);
    }

    public float x(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.vertexStart() + vertexIndex * 7]);
    }

    public float y(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.vertexStart() + vertexIndex * 7 + 1]);
    }

    public float z(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.vertexStart() + vertexIndex * 7 + 2]);
    }

    public boolean hasNormal(int vertexIndex) {
        return (this.normalFlags & 1 << vertexIndex) != 0;
    }

    public class_1160 copyNormal(int vertexIndex, class_1160 target) {
        if (this.hasNormal(vertexIndex)) {
            if (target == null) {
                target = new class_1160();
            }
            int normal = this.data[this.vertexStart() + 28 + vertexIndex];
            target.method_4949(NormalHelper.getPackedNormalComponent(normal, 0), NormalHelper.getPackedNormalComponent(normal, 1), NormalHelper.getPackedNormalComponent(normal, 2));
            return target;
        }
        return null;
    }

    public float normalX(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormalHelper.getPackedNormalComponent(this.data[this.baseIndex + 4 + 28 + vertexIndex], 0) : Float.NaN;
    }

    public float normalY(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormalHelper.getPackedNormalComponent(this.data[this.baseIndex + 4 + 28 + vertexIndex], 1) : Float.NaN;
    }

    public float normalZ(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormalHelper.getPackedNormalComponent(this.data[this.baseIndex + 4 + 28 + vertexIndex], 2) : Float.NaN;
    }

    public int lightmap(int vertexIndex) {
        return this.data[this.baseIndex + vertexIndex * 7 + 6 + 4];
    }

    protected int colorIndex(int vertexIndex, int textureIndex) {
        return textureIndex == 0 ? vertexIndex * 7 + 3 + 4 : 24 + textureIndex * 12 + vertexIndex * 3;
    }

    public int spriteColor(int vertexIndex, int textureIndex) {
        return this.data[this.baseIndex + this.colorIndex(vertexIndex, textureIndex)];
    }

    public float spriteU(int vertexIndex, int textureIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + this.colorIndex(vertexIndex, textureIndex) + 1]);
    }

    public float spriteV(int vertexIndex, int textureIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + this.colorIndex(vertexIndex, textureIndex) + 2]);
    }
}

