/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.indigo.renderer.IndigoRenderer;
import net.fabricmc.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.indigo.renderer.accessor.AccessBufferBuilder;
import net.fabricmc.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.indigo.renderer.mesh.MeshImpl;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public abstract class AbstractMeshConsumer
extends AbstractQuadRenderer
implements Consumer<Mesh> {
    private final Maker editorQuad = new Maker();

    protected AbstractMeshConsumer(BlockRenderInfo blockInfo, ToIntBiFunction<class_2680, class_2338> brightnessFunc, Int2ObjectFunction<AccessBufferBuilder> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(blockInfo, brightnessFunc, bufferFunc, aoCalc, transform);
    }

    @Override
    public void accept(Mesh mesh) {
        int stride;
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += stride) {
            RenderMaterialImpl.Value mat = RenderMaterialImpl.byIndex(data[index]);
            stride = EncodingFormat.stride(mat.spriteDepth());
            System.arraycopy(data, index, this.editorQuad.data(), 0, stride);
            this.editorQuad.load();
            this.renderQuad(this.editorQuad);
        }
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private void renderQuad(MutableQuadViewImpl q) {
        if (!this.transform.transform((MutableQuadView)this.editorQuad)) {
            return;
        }
        RenderMaterialImpl.Value mat = q.material();
        int textureCount = mat.spriteDepth();
        if (mat.hasAo && class_310.method_1588()) {
            this.aoCalc.compute(q, false);
        }
        this.applyOffsets(q);
        if (mat.hasEmissive && textureCount > 1) {
            this.captureLightmaps(q);
        }
        this.tesselateQuad(q, mat, 0);
        for (int t = 1; t < textureCount; ++t) {
            if (!mat.emissive(t)) {
                this.restoreLightmaps(q);
            }
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, q.spriteColor(i, t));
                q.sprite(i, 0, q.spriteU(i, t), q.spriteV(i, t));
            }
            this.tesselateQuad(q, mat, t);
        }
    }

    protected abstract void applyOffsets(MutableQuadViewImpl var1);

    private void tesselateQuad(MutableQuadViewImpl quad, RenderMaterialImpl.Value mat, int textureIndex) {
        int colorIndex = mat.disableColorIndex(textureIndex) ? -1 : quad.colorIndex();
        int renderLayer = this.blockInfo.layerIndexOrDefault(mat.blendMode(textureIndex));
        if (this.blockInfo.defaultAo && !mat.disableAo(textureIndex)) {
            if (mat.emissive(textureIndex)) {
                this.tesselateSmoothEmissive(quad, renderLayer, colorIndex);
            } else {
                this.tesselateSmooth(quad, renderLayer, colorIndex);
            }
        } else if (mat.emissive(textureIndex)) {
            this.tesselateFlatEmissive(quad, renderLayer, colorIndex, this.lightmaps);
        } else {
            this.tesselateFlat(quad, renderLayer, colorIndex);
        }
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = new int[36];
            this.material = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().spriteDepth(1).find();
        }

        public Maker emit() {
            if (AbstractMeshConsumer.this.blockInfo.shouldDrawFace(this.cullFace())) {
                AbstractMeshConsumer.this.renderQuad(this);
            }
            this.clear();
            return this;
        }
    }
}

