/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.function.ToIntBiFunction;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.indigo.renderer.accessor.AccessBufferBuilder;
import net.fabricmc.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.indigo.renderer.helper.ColorHelper;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public abstract class AbstractQuadRenderer {
    private static final int FULL_BRIGHTNESS = 0xF000F0;
    protected final ToIntBiFunction<class_2680, class_2338> brightnessFunc;
    protected final Int2ObjectFunction<AccessBufferBuilder> bufferFunc;
    protected final BlockRenderInfo blockInfo;
    protected final AoCalculator aoCalc;
    protected final RenderContext.QuadTransform transform;
    protected int[] lightmaps = new int[4];
    private final class_2338.class_2339 mpos = new class_2338.class_2339();

    AbstractQuadRenderer(BlockRenderInfo blockInfo, ToIntBiFunction<class_2680, class_2338> brightnessFunc, Int2ObjectFunction<AccessBufferBuilder> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        this.blockInfo = blockInfo;
        this.brightnessFunc = brightnessFunc;
        this.bufferFunc = bufferFunc;
        this.aoCalc = aoCalc;
        this.transform = transform;
    }

    private void colorizeQuad(MutableQuadViewImpl q, int blockColorIndex) {
        if (blockColorIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int blockColor = this.blockInfo.blockColor(blockColorIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColor(blockColor, q.spriteColor(i, 0))));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, int renderLayer) {
        ((AccessBufferBuilder)this.bufferFunc.get(renderLayer)).fabric_putVanillaData(quad.data(), quad.vertexStart());
    }

    protected void tesselateSmooth(MutableQuadViewImpl q, int renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, ColorHelper.maxBrightness(q.lightmap(i), this.aoCalc.light[i]));
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tesselateSmoothEmissive(MutableQuadViewImpl q, int renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tesselateFlat(MutableQuadViewImpl quad, int renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
        }
        this.bufferQuad(quad, renderLayer);
    }

    protected void tesselateFlatEmissive(MutableQuadViewImpl quad, int renderLayer, int blockColorIndex, int[] lightmaps) {
        this.colorizeQuad(quad, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(quad, renderLayer);
    }

    protected void captureLightmaps(MutableQuadViewImpl q) {
        int[] data = q.data();
        int[] lightmaps = this.lightmaps;
        lightmaps[0] = data[10];
        lightmaps[1] = data[17];
        lightmaps[2] = data[24];
        lightmaps[3] = data[31];
    }

    protected void restoreLightmaps(MutableQuadViewImpl q) {
        int[] data = q.data();
        int[] lightmaps = this.lightmaps;
        data[10] = lightmaps[0];
        data[17] = lightmaps[1];
        data[24] = lightmaps[2];
        data[31] = lightmaps[3];
    }

    int flatBrightness(MutableQuadViewImpl quad, class_2680 blockState, class_2338 pos) {
        this.mpos.method_10101((class_2382)pos);
        if ((quad.geometryFlags() & 4) != 0) {
            this.mpos.method_10098(quad.lightFace());
        }
        return this.brightnessFunc.applyAsInt(blockState, (class_2338)this.mpos);
    }
}

