/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.indigo.renderer.accessor.AccessBufferBuilder;
import net.fabricmc.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.render.AbstractMeshConsumer;
import net.fabricmc.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_778;

public class BlockRenderContext
extends AbstractRenderContext
implements RenderContext {
    private final BlockRenderInfo blockInfo = new BlockRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this::brightness, this::aoLevel);
    private final MeshConsumer meshConsumer = new MeshConsumer(this.blockInfo, this::brightness, (Int2ObjectFunction<AccessBufferBuilder>)((Int2ObjectFunction)this::outputBuffer), this.aoCalc, this::transform);
    private final Random random = new Random();
    private class_778 vanillaRenderer;
    private AccessBufferBuilder fabricBuffer;
    private long seed;
    private boolean isCallingVanilla = false;
    private boolean didOutput = false;
    private double offsetX;
    private double offsetY;
    private double offsetZ;

    public boolean isCallingVanilla() {
        return this.isCallingVanilla;
    }

    private int brightness(class_2680 blockState, class_2338 pos) {
        if (this.blockInfo.blockView == null) {
            return 0xF000F0;
        }
        return blockState.method_11632(this.blockInfo.blockView, pos);
    }

    private float aoLevel(class_2338 pos) {
        class_1920 blockView = this.blockInfo.blockView;
        if (blockView == null) {
            return 1.0f;
        }
        return blockView.method_8320(pos).method_11596((class_1922)blockView, pos);
    }

    private AccessBufferBuilder outputBuffer(int renderLayer) {
        this.didOutput = true;
        return this.fabricBuffer;
    }

    public boolean tesselate(class_778 vanillaRenderer, class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_287 buffer, long seed) {
        this.vanillaRenderer = vanillaRenderer;
        this.fabricBuffer = (AccessBufferBuilder)buffer;
        this.seed = seed;
        this.didOutput = false;
        this.aoCalc.clear();
        this.blockInfo.setBlockView(blockView);
        this.blockInfo.prepareForBlock(state, pos, model.method_4708());
        this.setupOffsets();
        ((FabricBakedModel)model).emitBlockQuads(blockView, state, pos, this.blockInfo.randomSupplier, (RenderContext)this);
        this.vanillaRenderer = null;
        this.blockInfo.release();
        this.fabricBuffer = null;
        return this.didOutput;
    }

    protected void acceptVanillaModel(class_1087 model) {
        this.isCallingVanilla = true;
        this.didOutput = this.didOutput && this.vanillaRenderer.method_3374(this.blockInfo.blockView, model, this.blockInfo.blockState, this.blockInfo.blockPos, (class_287)this.fabricBuffer, false, this.random, this.seed);
        this.isCallingVanilla = false;
    }

    private void setupOffsets() {
        AccessBufferBuilder buffer = this.fabricBuffer;
        class_2338 pos = this.blockInfo.blockPos;
        this.offsetX = buffer.fabric_offsetX() + (double)pos.method_10263();
        this.offsetY = buffer.fabric_offsetY() + (double)pos.method_10264();
        this.offsetZ = buffer.fabric_offsetZ() + (double)pos.method_10260();
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this::acceptVanillaModel;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }

    private class MeshConsumer
    extends AbstractMeshConsumer {
        MeshConsumer(BlockRenderInfo blockInfo, ToIntBiFunction<class_2680, class_2338> brightnessFunc, Int2ObjectFunction<AccessBufferBuilder> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
            super(blockInfo, brightnessFunc, bufferFunc, aoCalc, transform);
        }

        @Override
        protected void applyOffsets(MutableQuadViewImpl q) {
            double x = BlockRenderContext.this.offsetX;
            double y = BlockRenderContext.this.offsetY;
            double z = BlockRenderContext.this.offsetZ;
            for (int i = 0; i < 4; ++i) {
                q.pos(i, (float)((double)q.x(i) + x), (float)((double)q.y(i) + y), (float)((double)q.z(i) + z));
            }
        }
    }
}

