/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.fabricmc.indigo.renderer.accessor.AccessBufferBuilder;
import net.fabricmc.indigo.renderer.accessor.AccessChunkRenderer;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_842;
import net.minecraft.class_849;
import net.minecraft.class_851;
import net.minecraft.class_853;

public class ChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache;
    private final Long2FloatOpenHashMap aoLevelCache;
    private final BlockRenderInfo blockInfo;
    class_842 chunkTask;
    class_849 chunkData;
    class_851 chunkRenderer;
    class_1920 blockView;
    boolean[] resultFlags;
    private final AccessBufferBuilder[] buffers = new AccessBufferBuilder[4];
    private final class_1921[] LAYERS = class_1921.values();
    private double chunkOffsetX;
    private double chunkOffsetY;
    private double chunkOffsetZ;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;

    ChunkRenderInfo(BlockRenderInfo blockInfo) {
        this.blockInfo = blockInfo;
        this.brightnessCache = new Long2IntOpenHashMap();
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void setBlockView(class_853 blockView) {
        this.blockView = blockView;
    }

    void setChunkTask(class_842 chunkTask) {
        this.chunkTask = chunkTask;
    }

    void prepare(class_851 chunkRenderer, class_2338.class_2339 chunkOrigin, boolean[] resultFlags) {
        this.chunkData = this.chunkTask.method_3609();
        this.chunkRenderer = chunkRenderer;
        this.resultFlags = resultFlags;
        this.buffers[0] = null;
        this.buffers[1] = null;
        this.buffers[2] = null;
        this.buffers[3] = null;
        this.chunkOffsetX = -chunkOrigin.method_10263();
        this.chunkOffsetY = -chunkOrigin.method_10264();
        this.chunkOffsetZ = -chunkOrigin.method_10260();
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
    }

    void release() {
        this.chunkData = null;
        this.chunkTask = null;
        this.chunkRenderer = null;
        this.buffers[0] = null;
        this.buffers[1] = null;
        this.buffers[2] = null;
        this.buffers[3] = null;
    }

    void beginBlock() {
        class_2680 blockState = this.blockInfo.blockState;
        class_2338 blockPos = this.blockInfo.blockPos;
        this.offsetX = (float)(this.chunkOffsetX + (double)blockPos.method_10263());
        this.offsetY = (float)(this.chunkOffsetY + (double)blockPos.method_10264());
        this.offsetZ = (float)(this.chunkOffsetZ + (double)blockPos.method_10260());
        if (blockState.method_11614().method_16841() != class_2248.class_2250.field_10656) {
            class_243 offset = blockState.method_11599((class_1922)this.blockInfo.blockView, blockPos);
            this.offsetX += (float)offset.field_1352;
            this.offsetY += (float)offset.field_1351;
            this.offsetZ += (float)offset.field_1350;
        }
    }

    public AccessBufferBuilder getInitializedBuffer(int layerIndex) {
        this.resultFlags[layerIndex] = true;
        AccessBufferBuilder result = this.buffers[layerIndex];
        if (result == null) {
            class_287 builder = this.chunkTask.method_3600().method_3155(layerIndex);
            this.buffers[layerIndex] = (AccessBufferBuilder)builder;
            class_1921 layer = this.LAYERS[layerIndex];
            if (!this.chunkData.method_3649(layer)) {
                this.chunkData.method_3647(layer);
                ((AccessChunkRenderer)this.chunkRenderer).fabric_beginBufferBuilding(builder, this.blockInfo.blockPos);
            }
            result = (AccessBufferBuilder)builder;
        }
        return result;
    }

    void applyOffsets(MutableQuadViewImpl q) {
        for (int i = 0; i < 4; ++i) {
            q.pos(i, q.x(i) + this.offsetX, q.y(i) + this.offsetY, q.z(i) + this.offsetZ);
        }
    }

    int cachedBrightness(class_2680 blockState, class_2338 pos) {
        long key = pos.method_10063();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = blockState.method_11632(this.blockView, pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(class_2338 pos) {
        long key = pos.method_10063();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = this.blockView.method_8320(pos).method_11596((class_1922)this.blockView, pos);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

