/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.indigo.renderer.accessor.AccessBufferBuilder;
import net.fabricmc.indigo.renderer.helper.ColorHelper;
import net.fabricmc.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.indigo.renderer.mesh.MeshImpl;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.render.AbstractRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_325;
import net.minecraft.class_777;

public class ItemRenderContext
extends AbstractRenderContext
implements RenderContext {
    private final class_325 colorMap;
    private final Random random = new Random();
    class_287 bufferBuilder;
    AccessBufferBuilder fabricBuffer;
    private int color;
    private class_1799 itemStack;
    private VanillaQuadHandler vanillaHandler;
    private boolean smoothShading = false;
    private boolean enchantment = false;
    private final Supplier<Random> randomSupplier = () -> {
        Random result = this.random;
        result.setSeed(42L);
        return this.random;
    };
    public class_1799 enchantmentStack;
    private final int[] quadData = new int[36];
    private final Maker editorQuad = new Maker();
    private final Consumer<Mesh> meshConsumer = mesh -> {
        int stride;
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += stride) {
            RenderMaterialImpl.Value mat = RenderMaterialImpl.byIndex(data[index]);
            stride = EncodingFormat.stride(mat.spriteDepth());
            System.arraycopy(data, index, this.editorQuad.data(), 0, stride);
            this.editorQuad.load();
            this.renderQuad();
        }
    };
    private final Consumer<class_1087> fallbackConsumer = model -> {
        for (int i = 0; i < 7; ++i) {
            this.random.setSeed(42L);
            this.vanillaHandler.accept(this.bufferBuilder, model.method_4707((class_2680)null, ModelHelper.faceFromIndex((int)i), this.random), this.color, this.itemStack);
        }
    };

    public ItemRenderContext(class_325 colorMap) {
        this.colorMap = colorMap;
    }

    public void renderModel(FabricBakedModel model, int color, class_1799 stack, VanillaQuadHandler vanillaHandler) {
        this.color = color;
        if (stack.method_7960() && this.enchantmentStack != null) {
            this.enchantment = true;
            this.itemStack = this.enchantmentStack;
            this.enchantmentStack = null;
        } else {
            this.enchantment = false;
            this.itemStack = stack;
        }
        this.vanillaHandler = vanillaHandler;
        class_289 tessellator = class_289.method_1348();
        this.bufferBuilder = tessellator.method_1349();
        this.fabricBuffer = (AccessBufferBuilder)this.bufferBuilder;
        this.bufferBuilder.method_1328(7, class_290.field_1590);
        model.emitItemQuads(stack, this.randomSupplier, (RenderContext)this);
        tessellator.method_1350();
        if (this.smoothShading) {
            GlStateManager.shadeModel((int)7424);
            this.smoothShading = false;
        }
        this.bufferBuilder = null;
        this.fabricBuffer = null;
        tessellator = null;
        this.itemStack = null;
        this.vanillaHandler = null;
    }

    private void handleShading() {
        if (!this.smoothShading && this.editorQuad.hasVertexNormals()) {
            this.smoothShading = true;
            GlStateManager.shadeModel((int)7425);
        }
    }

    private int quadColor() {
        int colorIndex = this.editorQuad.colorIndex();
        int quadColor = this.color;
        if (!this.enchantment && quadColor == -1 && colorIndex != 1) {
            quadColor = this.colorMap.method_1704(this.itemStack, colorIndex);
            quadColor |= 0xFF000000;
        }
        return quadColor;
    }

    private void colorizeAndOutput(int quadColor) {
        Maker q = this.editorQuad;
        for (int i = 0; i < 4; ++i) {
            int c = q.spriteColor(i, 0);
            c = ColorHelper.multiplyColor(quadColor, c);
            q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(c));
        }
        this.fabricBuffer.fabric_putVanillaData(this.quadData, 4);
    }

    private void renderQuad() {
        Maker quad = this.editorQuad;
        if (!this.transform(this.editorQuad)) {
            return;
        }
        RenderMaterialImpl.Value mat = quad.material();
        int quadColor = this.quadColor();
        int textureCount = mat.spriteDepth();
        this.handleShading();
        quad.copyNormals(this.quadData, 4);
        this.colorizeAndOutput(!this.enchantment && mat.disableColorIndex(0) ? -1 : quadColor);
        if (!this.enchantment && textureCount > 1) {
            quad.copyColorUV(1, this.quadData, 4);
            this.colorizeAndOutput(mat.disableColorIndex(1) ? -1 : quadColor);
            if (textureCount == 3) {
                quad.copyColorUV(2, this.quadData, 4);
                this.colorizeAndOutput(mat.disableColorIndex(2) ? -1 : quadColor);
            }
        }
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = ItemRenderContext.this.quadData;
            this.clear();
        }

        public Maker emit() {
            ItemRenderContext.this.renderQuad();
            this.clear();
            return this;
        }
    }

    @FunctionalInterface
    public static interface VanillaQuadHandler {
        public void accept(class_287 var1, List<class_777> var2, int var3, class_1799 var4);
    }
}

