/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.indigo.renderer.IndigoRenderer;
import net.fabricmc.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.indigo.renderer.accessor.AccessBufferBuilder;
import net.fabricmc.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.indigo.renderer.render.ChunkRenderInfo;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_777;

public class TerrainFallbackConsumer
extends AbstractQuadRenderer
implements Consumer<class_1087> {
    private static RenderMaterialImpl.Value MATERIAL_FLAT = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().disableAo(0, true).find();
    private static RenderMaterialImpl.Value MATERIAL_SHADED = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().find();
    private final int[] editorBuffer = new int[28];
    private final ChunkRenderInfo chunkInfo;
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = TerrainFallbackConsumer.this.editorBuffer;
            this.material = MATERIAL_SHADED;
            this.baseIndex = -4;
        }

        public QuadEmitter emit() {
            throw new UnsupportedOperationException("Fallback consumer does not support .emit()");
        }
    };

    TerrainFallbackConsumer(BlockRenderInfo blockInfo, ChunkRenderInfo chunkInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(blockInfo, chunkInfo::cachedBrightness, (Int2ObjectFunction<AccessBufferBuilder>)((Int2ObjectFunction)chunkInfo::getInitializedBuffer), aoCalc, transform);
        this.chunkInfo = chunkInfo;
    }

    @Override
    public void accept(class_1087 model) {
        Supplier<Random> random = this.blockInfo.randomSupplier;
        RenderMaterialImpl.Value defaultMaterial = this.blockInfo.defaultAo && model.method_4708() ? MATERIAL_SHADED : MATERIAL_FLAT;
        class_2680 blockState = this.blockInfo.blockState;
        for (int i = 0; i < 6; ++i) {
            class_2350 face = ModelHelper.faceFromIndex((int)i);
            List quads = model.method_4707(blockState, face, random.get());
            int count = quads.size();
            if (count == 0 || !this.blockInfo.shouldDrawFace(face)) continue;
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.renderQuad(q, face, defaultMaterial);
            }
        }
        List quads = model.method_4707(blockState, null, random.get());
        int count = quads.size();
        if (count != 0) {
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.renderQuad(q, null, defaultMaterial);
            }
        }
    }

    private void renderQuad(class_777 quad, class_2350 cullFace, RenderMaterialImpl.Value defaultMaterial) {
        System.arraycopy(quad.method_3357(), 0, this.editorBuffer, 0, 28);
        this.editorQuad.cullFace(cullFace);
        class_2350 lightFace = quad.method_3358();
        this.editorQuad.lightFace(lightFace);
        this.editorQuad.nominalFace(lightFace);
        this.editorQuad.colorIndex(quad.method_3359());
        this.editorQuad.material(defaultMaterial);
        if (!this.transform.transform((MutableQuadView)this.editorQuad)) {
            return;
        }
        if (this.editorQuad.material().hasAo) {
            this.editorQuad.invalidateShape();
            this.aoCalc.compute(this.editorQuad, true);
            this.chunkInfo.applyOffsets(this.editorQuad);
            this.tesselateSmooth(this.editorQuad, this.blockInfo.defaultLayerIndex, this.editorQuad.colorIndex());
        } else {
            if (cullFace == null) {
                this.editorQuad.invalidateShape();
                this.editorQuad.geometryFlags();
            } else {
                this.editorQuad.geometryFlags(6);
            }
            this.chunkInfo.applyOffsets(this.editorQuad);
            this.tesselateFlat(this.editorQuad, this.blockInfo.defaultLayerIndex, this.editorQuad.colorIndex());
        }
    }
}

