/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.indigo.renderer.render;

import java.util.function.Consumer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.indigo.renderer.render.ChunkRenderInfo;
import net.fabricmc.indigo.renderer.render.TerrainBlockRenderInfo;
import net.fabricmc.indigo.renderer.render.TerrainFallbackConsumer;
import net.fabricmc.indigo.renderer.render.TerrainMeshConsumer;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_776;
import net.minecraft.class_842;
import net.minecraft.class_851;
import net.minecraft.class_853;

public class TerrainRenderContext
extends AbstractRenderContext
implements RenderContext {
    public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);
    private final TerrainBlockRenderInfo blockInfo = new TerrainBlockRenderInfo();
    private final ChunkRenderInfo chunkInfo = new ChunkRenderInfo(this.blockInfo);
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this.chunkInfo::cachedBrightness, this.chunkInfo::cachedAoLevel);
    private final TerrainMeshConsumer meshConsumer = new TerrainMeshConsumer(this.blockInfo, this.chunkInfo, this.aoCalc, this::transform);
    private final TerrainFallbackConsumer fallbackConsumer = new TerrainFallbackConsumer(this.blockInfo, this.chunkInfo, this.aoCalc, this::transform);
    private final class_776 blockRenderManager = class_310.method_1551().method_1541();

    public void setBlockView(class_853 blockView) {
        this.blockInfo.setBlockView((class_1920)blockView);
        this.chunkInfo.setBlockView(blockView);
    }

    public void setChunkTask(class_842 chunkTask) {
        this.chunkInfo.setChunkTask(chunkTask);
    }

    public TerrainRenderContext prepare(class_851 chunkRenderer, class_2338.class_2339 chunkOrigin, boolean[] resultFlags) {
        this.chunkInfo.prepare(chunkRenderer, chunkOrigin, resultFlags);
        return this;
    }

    public void release() {
        this.chunkInfo.release();
        this.blockInfo.release();
    }

    public boolean tesselateBlock(class_2680 blockState, class_2338 blockPos) {
        try {
            class_1087 model = this.blockRenderManager.method_3349(blockState);
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
            this.chunkInfo.beginBlock();
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable var9) {
            class_128 crashReport_1 = class_128.method_560((Throwable)var9, (String)"Tesselating block in world - Indigo Renderer");
            class_129 crashReportElement_1 = crashReport_1.method_562("Block being tesselated");
            class_129.method_586((class_129)crashReportElement_1, (class_2338)blockPos, (class_2680)blockState);
            throw new class_148(crashReport_1);
        }
        return this.chunkInfo.resultFlags[this.blockInfo.defaultLayerIndex];
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

