/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class BlockRenderInfo {
    private final BlockColors blockColorMap = Minecraft.getInstance().getBlockColors();
    private final BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
    public BlockAndTintGetter blockView;
    public BlockPos blockPos;
    public BlockState blockState;
    private boolean useAo;
    private boolean defaultAo;
    private ChunkSectionLayer defaultLayer;
    private boolean enableCulling;
    private int cullCompletionFlags;
    private int cullResultFlags;

    public void prepareForWorld(BlockAndTintGetter blockView, boolean enableCulling) {
        this.blockView = blockView;
        this.enableCulling = enableCulling;
    }

    public void prepareForBlock(BlockPos blockPos, BlockState blockState) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.useAo = Minecraft.useAmbientOcclusion();
        this.defaultAo = this.useAo && blockState.getLightEmission() == 0;
        this.defaultLayer = ItemBlockRenderTypes.getChunkRenderType((BlockState)blockState);
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    public void release() {
        this.blockView = null;
        this.blockPos = null;
        this.blockState = null;
    }

    public int blockColor(int tintIndex) {
        return 0xFF000000 | this.blockColorMap.getColor(this.blockState, this.blockView, this.blockPos, tintIndex);
    }

    public boolean effectiveAo(TriState aoMode) {
        return this.useAo && aoMode.orElse(this.defaultAo);
    }

    public ChunkSectionLayer effectiveRenderLayer(@Nullable ChunkSectionLayer quadRenderLayer) {
        return quadRenderLayer == null ? this.defaultLayer : quadRenderLayer;
    }

    public boolean shouldDrawSide(@Nullable Direction side) {
        if (side == null || !this.enableCulling) {
            return true;
        }
        int mask = 1 << side.get3DDataValue();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (Block.shouldRenderFace((BlockState)this.blockState, (BlockState)this.blockView.getBlockState((BlockPos)this.searchPos.setWithOffset((Vec3i)this.blockPos, side)), (Direction)side)) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }

    public boolean shouldCullSide(@Nullable Direction side) {
        return !this.shouldDrawSide(side);
    }
}

