/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.indigo.renderer;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessBatchingRenderCommandQueue;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ItemRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.MeshItemCommand;
import net.minecraft.class_10444;
import net.minecraft.class_11687;
import net.minecraft.class_11788;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4618;

@Mixin(class_11687.class)
abstract class ItemCommandRendererMixin {
	@Shadow
	@Final
	private class_4587 matrices;

	@Unique
	private final ItemRenderContext itemRenderContext = new ItemRenderContext();

	@Inject(method = "render", at = @At("RETURN"))
	private void onReturnRender(class_11788 queue, class_4597.class_4598 vertexConsumers, class_4618 outlineVertexConsumers, CallbackInfo ci) {
		for (MeshItemCommand itemCommand : ((AccessBatchingRenderCommandQueue) queue).fabric_getMeshItemCommands()) {
			matrices.method_22903();
			matrices.method_23760().method_66521(itemCommand.positionMatrix());

			itemRenderContext.renderItem(itemCommand.displayContext(), matrices, vertexConsumers, itemCommand.lightCoords(), itemCommand.overlayCoords(), itemCommand.tintLayers(), itemCommand.quads(), itemCommand.mesh(), itemCommand.renderLayer(), itemCommand.glintType(), false);

			if (itemCommand.outlineColor() != 0) {
				outlineVertexConsumers.method_23286(itemCommand.outlineColor());
				itemRenderContext.renderItem(itemCommand.displayContext(), matrices, outlineVertexConsumers, itemCommand.lightCoords(), itemCommand.overlayCoords(), itemCommand.tintLayers(), itemCommand.quads(), itemCommand.mesh(), itemCommand.renderLayer(), class_10444.class_10445.field_55341, true);
			}

			matrices.method_22909();
		}
	}
}
