/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.helper;

import java.nio.ByteOrder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ColorHelper {
    private static final boolean BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private ColorHelper() {
    }

    public static int maxLight(int l0, int l1) {
        if (l0 == 0) {
            return l1;
        }
        if (l1 == 0) {
            return l0;
        }
        return Math.max(l0 & 0xFFFF, l1 & 0xFFFF) | Math.max(l0 & 0xFFFF0000, l1 & 0xFFFF0000);
    }

    public static int toVanillaColor(int color) {
        if (color == -1) {
            return -1;
        }
        if (BIG_ENDIAN) {
            return (color & 0xFFFFFF) << 8 | (color & 0xFF000000) >>> 24;
        }
        return color & 0xFF00FF00 | (color & 0xFF0000) >>> 16 | (color & 0xFF) << 16;
    }

    public static int fromVanillaColor(int color) {
        if (color == -1) {
            return -1;
        }
        if (BIG_ENDIAN) {
            return (color & 0xFFFFFF00) >>> 8 | (color & 0xFF) << 24;
        }
        return color & 0xFF00FF00 | (color & 0xFF0000) >>> 16 | (color & 0xFF) << 16;
    }
}

