/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.fabricmc.fabric.api.renderer.v1.render.BlockVertexConsumerProvider;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractTerrainRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.LightDataProvider;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TerrainLikeRenderContext
extends AbstractTerrainRenderContext {
    public static final ThreadLocal<TerrainLikeRenderContext> POOL = ThreadLocal.withInitial(TerrainLikeRenderContext::new);
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();
    private BlockVertexConsumerProvider vertexConsumers;

    @Override
    protected LightDataProvider createLightDataProvider(final BlockRenderInfo blockInfo) {
        return new LightDataProvider(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int light(BlockPos pos, BlockState state) {
                return LevelRenderer.getLightCoords((LevelRenderer.BrightnessGetter)LevelRenderer.BrightnessGetter.DEFAULT, (BlockAndTintGetter)blockInfo.blockView, (BlockState)state, (BlockPos)pos);
            }

            @Override
            public float ao(BlockPos pos, BlockState state) {
                return AoLuminanceFix.INSTANCE.apply((BlockGetter)blockInfo.blockView, pos, state);
            }
        };
    }

    @Override
    protected VertexConsumer getVertexConsumer(ChunkSectionLayer layer) {
        return this.vertexConsumers.getBuffer(layer);
    }

    public void bufferModel(BlockAndTintGetter blockView, BlockStateModel model, BlockState state, BlockPos pos, PoseStack matrixStack, BlockVertexConsumerProvider vertexConsumers, boolean cull, long seed, int overlay) {
        try {
            Vec3 offset = state.getOffset(pos);
            matrixStack.translate(offset.x, offset.y, offset.z);
            this.matrices = matrixStack.last();
            this.overlay = overlay;
            this.vertexConsumers = vertexConsumers;
            this.blockInfo.prepareForWorld(blockView, cull);
            this.random.setSeed(seed);
            this.prepare(pos, state);
            model.emitQuads(this.getEmitter(), blockView, pos, state, this.random, this.blockInfo::shouldCullSide);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Tessellating block model - Indigo Renderer");
            CrashReportCategory crashReportSection = crashReport.addCategory("Block model being tessellated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportSection, (LevelHeightAccessor)blockView, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashReport);
        }
        finally {
            this.blockInfo.release();
            this.matrices = null;
            this.vertexConsumers = null;
        }
    }
}

