/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.renderer.v1.Renderer;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.client.renderer.v1.render.BlockMultiBufferSource;
import net.fabricmc.fabric.api.client.renderer.v1.render.ChunkSectionLayerHelper;
import net.fabricmc.fabric.api.client.renderer.v1.render.FabricModelBlockRenderer;
import net.fabricmc.fabric.api.client.renderer.v1.render.ItemRenderTypeGetter;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessLayerRenderState;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableMeshImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.SimpleBlockRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainLikeRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.BlockRenderDispatcherAccessor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class IndigoRenderer
implements Renderer {
    public static final IndigoRenderer INSTANCE = new IndigoRenderer();

    private IndigoRenderer() {
    }

    public MutableMesh mutableMesh() {
        return new MutableMeshImpl();
    }

    public void tesselateBlock(ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BlockStateModel model, BlockState state, BlockPos pos, PoseStack poseStack, BlockMultiBufferSource bufferSource, @Nullable Predicate<ChunkSectionLayer> layerFilter, boolean cull, long seed, int overlay) {
        TerrainLikeRenderContext.POOL.get().bufferModel(level, model, state, pos, poseStack, bufferSource, layerFilter, cull, seed, overlay);
    }

    public void renderModel(PoseStack.Pose pose, BlockMultiBufferSource bufferSource, @Nullable Predicate<ChunkSectionLayer> layerFilter, BlockStateModel model, float red, float green, float blue, int light, int overlay, BlockAndTintGetter level, BlockPos pos, BlockState state) {
        SimpleBlockRenderContext.POOL.get().bufferModel(pose, bufferSource, layerFilter, model, red, green, blue, light, overlay, level, pos, state);
    }

    public void renderSingleBlock(BlockRenderDispatcher renderDispatcher, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, @Nullable Predicate<ChunkSectionLayer> layerFilter, int light, int overlay, BlockAndTintGetter level, BlockPos pos) {
        RenderShape renderShape = state.getRenderShape();
        if (renderShape != RenderShape.INVISIBLE) {
            BlockStateModel model = renderDispatcher.getBlockModel(state);
            int tint = ((BlockRenderDispatcherAccessor)renderDispatcher).getBlockColors().getColor(state, null, null, 0);
            float red = (float)(tint >> 16 & 0xFF) / 255.0f;
            float green = (float)(tint >> 8 & 0xFF) / 255.0f;
            float blue = (float)(tint & 0xFF) / 255.0f;
            FabricModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (BlockMultiBufferSource)ChunkSectionLayerHelper.entityDelegate((MultiBufferSource)bufferSource), layerFilter, (BlockStateModel)model, (float)red, (float)green, (float)blue, (int)light, (int)overlay, (BlockAndTintGetter)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public QuadEmitter getLayerRenderStateEmitter(ItemStackRenderState.LayerRenderState layer) {
        return ((AccessLayerRenderState)layer).fabric_getMutableMesh().emitter();
    }

    public void setLayerRenderTypeGetter(ItemStackRenderState.LayerRenderState layer, ItemRenderTypeGetter renderTypeGetter) {
        ((AccessLayerRenderState)layer).fabric_setRenderTypeGetter(renderTypeGetter);
    }
}

