/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.mesh;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.client.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.Nullable;

public final class EncodingFormat {
    static final int HEADER_BITS = 0;
    static final int HEADER_FACE_NORMAL = 1;
    static final int HEADER_TINT_INDEX = 2;
    static final int HEADER_TAG = 3;
    public static final int HEADER_STRIDE = 4;
    static final int VERTEX_X;
    static final int VERTEX_Y;
    static final int VERTEX_Z;
    static final int VERTEX_COLOR;
    static final int VERTEX_U;
    static final int VERTEX_V;
    static final int VERTEX_LIGHTMAP;
    static final int VERTEX_NORMAL;
    public static final int VERTEX_STRIDE;
    public static final int QUAD_STRIDE;
    public static final int QUAD_STRIDE_BYTES;
    public static final int TOTAL_STRIDE;
    private static final int DIRECTION_COUNT;
    private static final int NULLABLE_DIRECTION_COUNT;
    private static final @Nullable ChunkSectionLayer[] NULLABLE_CHUNK_SECTION_LAYERS;
    private static final int NULLABLE_CHUNK_SECTION_LAYER_COUNT;
    private static final TriState[] TRI_STATES;
    private static final int TRI_STATE_COUNT;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType[] NULLABLE_FOIL_TYPES;
    private static final int NULLABLE_FOIL_TYPE_COUNT;
    private static final ShadeMode[] SHADE_MODES;
    private static final int SHADE_MODE_COUNT;
    private static final QuadAtlas[] QUAD_ATLASES;
    private static final int QUAD_ATLAS_COUNT;
    private static final int NULL_CHUNK_LAYER_INDEX;
    private static final int NULL_FOIL_TYPE_INDEX;
    private static final int CULL_BIT_LENGTH;
    private static final int LIGHT_BIT_LENGTH;
    private static final int NORMALS_BIT_LENGTH = 4;
    private static final int GEOMETRY_BIT_LENGTH = 3;
    private static final int CHUNK_LAYER_BIT_LENGTH;
    private static final int EMISSIVE_BIT_LENGTH = 1;
    private static final int DIFFUSE_BIT_LENGTH = 1;
    private static final int AO_BIT_LENGTH;
    private static final int FOIL_TYPE_BIT_LENGTH;
    private static final int SHADE_MODE_BIT_LENGTH;
    private static final int QUAD_ATLAS_BIT_LENGTH;
    private static final int CULL_BIT_OFFSET = 0;
    private static final int LIGHT_BIT_OFFSET;
    private static final int NORMALS_BIT_OFFSET;
    private static final int GEOMETRY_BIT_OFFSET;
    private static final int CHUNK_LAYER_BIT_OFFSET;
    private static final int EMISSIVE_BIT_OFFSET;
    private static final int DIFFUSE_BIT_OFFSET;
    private static final int AO_BIT_OFFSET;
    private static final int FOIL_TYPE_BIT_OFFSET;
    private static final int SHADE_MODE_BIT_OFFSET;
    private static final int QUAD_ATLAS_BIT_OFFSET;
    private static final int TOTAL_BIT_LENGTH;
    private static final int CULL_MASK;
    private static final int LIGHT_MASK;
    private static final int NORMALS_MASK;
    private static final int GEOMETRY_MASK;
    private static final int CHUNK_LAYER_MASK;
    private static final int EMISSIVE_MASK;
    private static final int DIFFUSE_MASK;
    private static final int AO_MASK;
    private static final int FOIL_TYPE_MASK;
    private static final int SHADE_MODE_MASK;
    private static final int QUAD_ATLAS_MASK;

    private EncodingFormat() {
    }

    private static int bitMask(int bitLength, int bitOffset) {
        return (1 << bitLength) - 1 << bitOffset;
    }

    static @Nullable Direction cullFace(int bits) {
        return ModelHelper.faceFromIndex((int)((bits & CULL_MASK) >>> 0));
    }

    static int cullFace(int bits, @Nullable Direction face) {
        return bits & ~CULL_MASK | ModelHelper.toFaceIndex((Direction)face) << 0;
    }

    static Direction lightFace(int bits) {
        return ModelHelper.faceFromIndex((int)((bits & LIGHT_MASK) >>> LIGHT_BIT_OFFSET));
    }

    static int lightFace(int bits, Direction face) {
        return bits & ~LIGHT_MASK | ModelHelper.toFaceIndex((Direction)face) << LIGHT_BIT_OFFSET;
    }

    static int normalFlags(int bits) {
        return (bits & NORMALS_MASK) >>> NORMALS_BIT_OFFSET;
    }

    static int normalFlags(int bits, int normalFlags) {
        return bits & ~NORMALS_MASK | normalFlags << NORMALS_BIT_OFFSET & NORMALS_MASK;
    }

    static int geometryFlags(int bits) {
        return (bits & GEOMETRY_MASK) >>> GEOMETRY_BIT_OFFSET;
    }

    static int geometryFlags(int bits, int geometryFlags) {
        return bits & ~GEOMETRY_MASK | geometryFlags << GEOMETRY_BIT_OFFSET & GEOMETRY_MASK;
    }

    static @Nullable ChunkSectionLayer chunkLayer(int bits) {
        return NULLABLE_CHUNK_SECTION_LAYERS[(bits & CHUNK_LAYER_MASK) >>> CHUNK_LAYER_BIT_OFFSET];
    }

    static int chunkLayer(int bits, @Nullable ChunkSectionLayer layer) {
        int index = layer == null ? NULL_CHUNK_LAYER_INDEX : layer.ordinal();
        return bits & ~CHUNK_LAYER_MASK | index << CHUNK_LAYER_BIT_OFFSET;
    }

    static boolean emissive(int bits) {
        return (bits & EMISSIVE_MASK) != 0;
    }

    static int emissive(int bits, boolean emissive) {
        return emissive ? bits | EMISSIVE_MASK : bits & ~EMISSIVE_MASK;
    }

    static boolean diffuseShade(int bits) {
        return (bits & DIFFUSE_MASK) != 0;
    }

    static int diffuseShade(int bits, boolean shade) {
        return shade ? bits | DIFFUSE_MASK : bits & ~DIFFUSE_MASK;
    }

    static TriState ambientOcclusion(int bits) {
        return TRI_STATES[(bits & AO_MASK) >>> AO_BIT_OFFSET];
    }

    static int ambientOcclusion(int bits, TriState ao) {
        return bits & ~AO_MASK | ao.ordinal() << AO_BIT_OFFSET;
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType foilType(int bits) {
        return NULLABLE_FOIL_TYPES[(bits & FOIL_TYPE_MASK) >>> FOIL_TYPE_BIT_OFFSET];
    }

    static int foilType(int bits, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType foilType) {
        int index = foilType == null ? NULL_FOIL_TYPE_INDEX : foilType.ordinal();
        return bits & ~FOIL_TYPE_MASK | index << FOIL_TYPE_BIT_OFFSET;
    }

    static ShadeMode shadeMode(int bits) {
        return SHADE_MODES[(bits & SHADE_MODE_MASK) >>> SHADE_MODE_BIT_OFFSET];
    }

    static int shadeMode(int bits, ShadeMode mode) {
        return bits & ~SHADE_MODE_MASK | mode.ordinal() << SHADE_MODE_BIT_OFFSET;
    }

    static QuadAtlas quadAtlas(int bits) {
        return QUAD_ATLASES[(bits & QUAD_ATLAS_MASK) >>> QUAD_ATLAS_BIT_OFFSET];
    }

    static int quadAtlas(int bits, QuadAtlas quadAtlas) {
        return bits & ~QUAD_ATLAS_MASK | quadAtlas.ordinal() << QUAD_ATLAS_BIT_OFFSET;
    }

    static {
        VertexFormat format = DefaultVertexFormat.BLOCK;
        VERTEX_X = 4;
        VERTEX_Y = 5;
        VERTEX_Z = 6;
        VERTEX_COLOR = 7;
        VERTEX_U = 8;
        VERTEX_V = VERTEX_U + 1;
        VERTEX_LIGHTMAP = 10;
        VERTEX_NORMAL = 11;
        VERTEX_STRIDE = format.getVertexSize() / 4;
        QUAD_STRIDE = VERTEX_STRIDE * 4;
        QUAD_STRIDE_BYTES = QUAD_STRIDE * 4;
        TOTAL_STRIDE = 4 + QUAD_STRIDE;
        DIRECTION_COUNT = Direction.values().length;
        NULLABLE_DIRECTION_COUNT = DIRECTION_COUNT + 1;
        NULLABLE_CHUNK_SECTION_LAYERS = (ChunkSectionLayer[])ArrayUtils.add((Object[])ChunkSectionLayer.values(), null);
        NULLABLE_CHUNK_SECTION_LAYER_COUNT = NULLABLE_CHUNK_SECTION_LAYERS.length;
        TRI_STATES = TriState.values();
        TRI_STATE_COUNT = TRI_STATES.length;
        NULLABLE_FOIL_TYPES = (ItemStackRenderState.FoilType[])ArrayUtils.add((Object[])ItemStackRenderState.FoilType.values(), null);
        NULLABLE_FOIL_TYPE_COUNT = NULLABLE_FOIL_TYPES.length;
        SHADE_MODES = ShadeMode.values();
        SHADE_MODE_COUNT = SHADE_MODES.length;
        QUAD_ATLASES = QuadAtlas.values();
        QUAD_ATLAS_COUNT = QUAD_ATLASES.length;
        NULL_CHUNK_LAYER_INDEX = NULLABLE_CHUNK_SECTION_LAYER_COUNT - 1;
        NULL_FOIL_TYPE_INDEX = NULLABLE_FOIL_TYPE_COUNT - 1;
        CULL_BIT_LENGTH = Mth.ceillog2((int)NULLABLE_DIRECTION_COUNT);
        LIGHT_BIT_LENGTH = Mth.ceillog2((int)DIRECTION_COUNT);
        CHUNK_LAYER_BIT_LENGTH = Mth.ceillog2((int)NULLABLE_CHUNK_SECTION_LAYER_COUNT);
        AO_BIT_LENGTH = Mth.ceillog2((int)TRI_STATE_COUNT);
        FOIL_TYPE_BIT_LENGTH = Mth.ceillog2((int)NULLABLE_FOIL_TYPE_COUNT);
        SHADE_MODE_BIT_LENGTH = Mth.ceillog2((int)SHADE_MODE_COUNT);
        QUAD_ATLAS_BIT_LENGTH = Mth.ceillog2((int)QUAD_ATLAS_COUNT);
        LIGHT_BIT_OFFSET = 0 + CULL_BIT_LENGTH;
        NORMALS_BIT_OFFSET = LIGHT_BIT_OFFSET + LIGHT_BIT_LENGTH;
        GEOMETRY_BIT_OFFSET = NORMALS_BIT_OFFSET + 4;
        CHUNK_LAYER_BIT_OFFSET = GEOMETRY_BIT_OFFSET + 3;
        EMISSIVE_BIT_OFFSET = CHUNK_LAYER_BIT_OFFSET + CHUNK_LAYER_BIT_LENGTH;
        DIFFUSE_BIT_OFFSET = EMISSIVE_BIT_OFFSET + 1;
        AO_BIT_OFFSET = DIFFUSE_BIT_OFFSET + 1;
        FOIL_TYPE_BIT_OFFSET = AO_BIT_OFFSET + AO_BIT_LENGTH;
        SHADE_MODE_BIT_OFFSET = FOIL_TYPE_BIT_OFFSET + FOIL_TYPE_BIT_LENGTH;
        QUAD_ATLAS_BIT_OFFSET = SHADE_MODE_BIT_OFFSET + SHADE_MODE_BIT_LENGTH;
        TOTAL_BIT_LENGTH = QUAD_ATLAS_BIT_OFFSET + QUAD_ATLAS_BIT_LENGTH;
        CULL_MASK = EncodingFormat.bitMask(CULL_BIT_LENGTH, 0);
        LIGHT_MASK = EncodingFormat.bitMask(LIGHT_BIT_LENGTH, LIGHT_BIT_OFFSET);
        NORMALS_MASK = EncodingFormat.bitMask(4, NORMALS_BIT_OFFSET);
        GEOMETRY_MASK = EncodingFormat.bitMask(3, GEOMETRY_BIT_OFFSET);
        CHUNK_LAYER_MASK = EncodingFormat.bitMask(CHUNK_LAYER_BIT_LENGTH, CHUNK_LAYER_BIT_OFFSET);
        EMISSIVE_MASK = EncodingFormat.bitMask(1, EMISSIVE_BIT_OFFSET);
        DIFFUSE_MASK = EncodingFormat.bitMask(1, DIFFUSE_BIT_OFFSET);
        AO_MASK = EncodingFormat.bitMask(AO_BIT_LENGTH, AO_BIT_OFFSET);
        FOIL_TYPE_MASK = EncodingFormat.bitMask(FOIL_TYPE_BIT_LENGTH, FOIL_TYPE_BIT_OFFSET);
        SHADE_MODE_MASK = EncodingFormat.bitMask(SHADE_MODE_BIT_LENGTH, SHADE_MODE_BIT_OFFSET);
        QUAD_ATLAS_MASK = EncodingFormat.bitMask(QUAD_ATLAS_BIT_LENGTH, QUAD_ATLAS_BIT_OFFSET);
        Preconditions.checkArgument((TOTAL_BIT_LENGTH <= 32 ? 1 : 0) != 0, (String)"Indigo header encoding bit count (%s) exceeds integer bit length)", (int)TOTAL_STRIDE);
    }
}

