/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.MeshView;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.client.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.client.renderer.v1.render.ItemRenderTypeGetter;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.ItemRendererAccessor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4f;
import org.jspecify.annotations.Nullable;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final int FOIL_TYPE_COUNT = ItemStackRenderState.FoilType.values().length;
    private ItemDisplayContext displayContext;
    private MultiBufferSource bufferSource;
    private int light;
    private int[] tints;
    private RenderType defaultRenderType;
    private @Nullable ItemRenderTypeGetter renderTypeGetter;
    private ItemStackRenderState.FoilType defaultFoilType;
    private boolean ignoreQuadFoilType;
    private boolean translucent;
    private PoseStack.Pose specialFoilPose;
    private final VertexConsumer[] vertexConsumerCache = new VertexConsumer[3 * FOIL_TYPE_COUNT];

    public void renderItem(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, int[] tints, List<BakedQuad> vanillaQuads, MeshView mesh, RenderType renderType, @Nullable ItemRenderTypeGetter renderTypeGetter, ItemStackRenderState.FoilType foilType, boolean ignoreQuadFoilType, boolean translucent) {
        this.displayContext = displayContext;
        this.pose = poseStack.last();
        this.bufferSource = bufferSource;
        this.light = light;
        this.overlay = overlay;
        this.tints = tints;
        this.defaultRenderType = renderType;
        this.renderTypeGetter = renderTypeGetter;
        this.defaultFoilType = foilType;
        this.ignoreQuadFoilType = ignoreQuadFoilType;
        this.translucent = translucent;
        this.bufferQuads(vanillaQuads, mesh);
        this.pose = null;
        this.bufferSource = null;
        this.tints = null;
        this.defaultRenderType = null;
        this.renderTypeGetter = null;
        this.specialFoilPose = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    private void bufferQuads(List<BakedQuad> vanillaQuads, MeshView mesh) {
        QuadEmitter emitter = this.getEmitter();
        int vanillaQuadCount = vanillaQuads.size();
        for (int i = 0; i < vanillaQuadCount; ++i) {
            BakedQuad q = vanillaQuads.get(i);
            emitter.fromBakedQuad(q);
            emitter.emit();
        }
        mesh.outputTo(emitter);
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        RenderType renderType = this.getRenderType(quad.atlas(), quad.chunkLayer());
        if (renderType.hasBlending() != this.translucent) {
            return;
        }
        VertexConsumer vertexConsumer = this.getVertexConsumer(renderType, quad.foilType());
        this.tintQuad(quad);
        this.shadeQuad(quad, quad.emissive());
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex >= 0 && tintIndex < this.tints.length) {
            int tint = this.tints[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ARGB.multiply((int)quad.color(i), (int)tint));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int light = this.light;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
            }
        }
    }

    private RenderType getRenderType(QuadAtlas quadAtlas, @Nullable ChunkSectionLayer quadLayer) {
        RenderType renderType;
        if (this.renderTypeGetter != null) {
            renderType = this.renderTypeGetter.renderType(quadAtlas, quadLayer);
            if (renderType == null) {
                renderType = this.defaultRenderType;
            }
        } else {
            renderType = this.defaultRenderType;
        }
        return renderType;
    }

    private VertexConsumer getVertexConsumer(RenderType renderType, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType quadFoilType) {
        ItemStackRenderState.FoilType foilType = this.ignoreQuadFoilType || quadFoilType == null ? this.defaultFoilType : quadFoilType;
        if (renderType == Sheets.translucentItemSheet()) {
            cacheIndex = 0;
        } else if (renderType == Sheets.cutoutBlockSheet()) {
            cacheIndex = FOIL_TYPE_COUNT;
        } else if (renderType == Sheets.translucentBlockItemSheet()) {
            cacheIndex = 2 * FOIL_TYPE_COUNT;
        } else {
            return this.createVertexConsumer(renderType, foilType);
        }
        VertexConsumer vertexConsumer = this.vertexConsumerCache[cacheIndex += foilType.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(renderType, foilType);
        }
        return vertexConsumer;
    }

    private VertexConsumer createVertexConsumer(RenderType renderType, ItemStackRenderState.FoilType foilType) {
        if (foilType == ItemStackRenderState.FoilType.SPECIAL) {
            if (this.specialFoilPose == null) {
                this.specialFoilPose = this.pose.copy();
                if (this.displayContext == ItemDisplayContext.GUI) {
                    MatrixUtil.mulComponentWise((Matrix4f)this.specialFoilPose.pose(), (float)0.5f);
                } else if (this.displayContext.firstPerson()) {
                    MatrixUtil.mulComponentWise((Matrix4f)this.specialFoilPose.pose(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.fabric_getSpecialFoilBuffer(this.bufferSource, renderType, this.specialFoilPose);
        }
        return ItemRenderer.getFoilBuffer((MultiBufferSource)this.bufferSource, (RenderType)renderType, (boolean)true, (foilType != ItemStackRenderState.FoilType.NONE ? 1 : 0) != 0);
    }
}

